/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.resolvers;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.model.resolvers.EntryPointNotFoundException;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.util.ExceptionUtils;

public class MethodEntryPointsTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/resolvers/method-entrypoints-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/resolvers/method-entrypoints-config-flow.xml"});
    }

    public MethodEntryPointsTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testTooManySatisfiableMethods() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://service", (Object)"hello", null);
        Assert.assertNotNull((Object)message);
        Assert.assertNotNull((Object)message.getExceptionPayload());
        Assert.assertEquals(EntryPointNotFoundException.class, message.getExceptionPayload().getRootException().getClass());
        Assert.assertTrue((ExceptionUtils.getRootCauseMessage((Throwable)message.getExceptionPayload().getException()).indexOf("Found too many possible methods on object") > -1 ? 1 : 0) != 0);
    }

    @Test
    public void testBadMethodName() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://service?method=foo", (Object)"hello", null);
        Assert.assertNotNull((Object)message);
        Assert.assertNotNull((Object)message.getExceptionPayload());
        Assert.assertEquals(EntryPointNotFoundException.class, message.getExceptionPayload().getRootException().getClass());
    }

    @Test
    public void testValidCallToReverse() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage msg = MethodEntryPointsTestCase.getTestMuleMessage((Object)"hello");
        msg.setOutboundProperty("method", (Object)"reverseString");
        MuleMessage message = client.send("vm://service", msg);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"olleh", (Object)message.getPayloadAsString());
    }

    @Test
    public void testValidCallToUpperCase() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage msg = MethodEntryPointsTestCase.getTestMuleMessage((Object)"hello");
        msg.setOutboundProperty("method", (Object)"upperCaseString");
        MuleMessage message = client.send("vm://service", msg);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"HELLO", (Object)message.getPayloadAsString());
    }

    @Test
    public void testValidCallToReverseMethodSetOnEndpoint() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://service2-reverseString", (Object)"hello", null);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"olleh", (Object)message.getPayloadAsString());
    }

    @Test
    public void testValidCallToUpperCaseMethodSetOnEndpoint() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://service2-upperCaseString", (Object)"hello", null);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)message.getPayloadAsString(), (Object)"HELLO");
    }

    @Test
    public void testValidCallToReverseMethodSetAsHeader() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("method", "reverseString");
        MuleMessage message = client.send("vm://service", (Object)"hello", props);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"olleh", (Object)message.getPayloadAsString());
    }

    @Test
    public void testValidCallToUpperCaseMethodSetAsHeader() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("method", "upperCaseString");
        MuleMessage message = client.send("vm://service", (Object)"hello", props);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"HELLO", (Object)message.getPayloadAsString());
    }
}

