/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.messaging.meps;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.util.WebServiceOnlineCheck;

@Ignore(value="MULE-6926: flaky test (Relies on an external server which can go offline after isDisabledInThisEnvironment is executed)")
public class MessagePropertiesPropagationTestCase
extends FunctionalTestCase {
    protected boolean isFailOnTimeout() {
        return false;
    }

    protected boolean isDisabledInThisEnvironment() {
        return !WebServiceOnlineCheck.isWebServiceOnline();
    }

    protected String getConfigFile() {
        return "org/mule/test/integration/messaging/meps/message-properties-propagation.xml";
    }

    @Test
    public void testPropagatedPropertiesWithHttpTransport() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("Content-Type", "application/x-www-form-urlencoded");
        props.put("MULE_CORRELATION_ID", "TestID");
        props.put("MULE_CORRELATION_GROUP_SIZE", "TestGroupSize");
        props.put("MULE_CORRELATION_SEQUENCE", "TestSequence");
        MuleMessage response = client.send("vm://httpService1", (Object)"symbol=IBM", props);
        Assert.assertNotNull((Object)response);
        this.checkPayLoad(response.getPayloadAsString());
        Assert.assertEquals((Object)"TestID", (Object)response.getOutboundProperty("MULE_CORRELATION_ID"));
        Assert.assertEquals((Object)"TestGroupSize", (Object)response.getOutboundProperty("MULE_CORRELATION_GROUP_SIZE"));
        Assert.assertEquals((Object)"TestSequence", (Object)response.getOutboundProperty("MULE_CORRELATION_SEQUENCE"));
    }

    @Test
    public void testPropagatedPropertiesWithCxfTransport() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("MULE_CORRELATION_ID", "TestID");
        props.put("MULE_CORRELATION_GROUP_SIZE", "TestGroupSize");
        props.put("MULE_CORRELATION_SEQUENCE", "TestSequence");
        MuleMessage response = client.send("vm://cxfService1", (Object)"IBM", props);
        Assert.assertNotNull((Object)response);
        this.checkPayLoad(response.getPayloadAsString());
        Assert.assertEquals((Object)"TestID", (Object)response.getOutboundProperty("MULE_CORRELATION_ID"));
        Assert.assertEquals((Object)"TestGroupSize", (Object)response.getOutboundProperty("MULE_CORRELATION_GROUP_SIZE"));
        Assert.assertEquals((Object)"TestSequence", (Object)response.getOutboundProperty("MULE_CORRELATION_SEQUENCE"));
    }

    @Test
    public void testNotPropagatedPropertiesWithHttpTransport() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("Content-Type", "application/x-www-form-urlencoded");
        props.put("some", "thing");
        props.put("other", "stuff");
        props.put("Content-Type", "text/bizarre;charset=utf-16");
        MuleMessage response = client.send("vm://httpService1", (Object)"symbol=IBM", props);
        Assert.assertNotNull((Object)response);
        Assert.assertNull((Object)response.getInboundProperty("some"));
        Assert.assertNull((Object)response.getInboundProperty("other"));
        Assert.assertEquals((Object)"text/plain; charset=utf-8", (Object)response.getInboundProperty("Content-Type"));
        Assert.assertEquals((Object)"utf-8", (Object)response.getEncoding());
    }

    @Test
    public void testNotPropagatedPropertiesWithCxfTransport() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("some", "thing");
        props.put("other", "stuff");
        props.put("Content-Type", "text/bizarre;charset=utf-16");
        MuleMessage response = client.send("vm://cxfService1", (Object)"IBM", props);
        Assert.assertNotNull((Object)response);
        Assert.assertNull((Object)response.getInboundProperty("some"));
        Assert.assertNull((Object)response.getInboundProperty("other"));
        Assert.assertEquals((Object)"text/xml; charset=utf-8", (Object)response.getInboundProperty("Content-Type"));
        Assert.assertEquals((Object)"utf-8", (Object)response.getEncoding());
    }

    @Test
    public void testForcePropagatedPropertiesWithHttpTransport() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("Content-Type", "application/x-www-form-urlencoded");
        props.put("some", "thing");
        props.put("other", "stuff");
        MuleMessage response = client.send("vm://httpService2", (Object)"symbol=IBM", props);
        Assert.assertNotNull((Object)response);
        this.checkPayLoad(response.getPayloadAsString());
        Assert.assertEquals((Object)"thing", (Object)response.getInboundProperty("some"));
        Assert.assertEquals((Object)"stuff", (Object)response.getInboundProperty("other"));
    }

    public void xtestForcePropagatedPropertiesWithCxfTransport() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("some", "thing");
        props.put("other", "stuff");
        MuleMessage response = client.send("vm://cxfService2", (Object)"symbol=IBM", props);
        Assert.assertNotNull((Object)response);
        this.checkPayLoad(response.getPayloadAsString());
        Assert.assertEquals((Object)"thing", (Object)response.getOutboundProperty("some"));
        Assert.assertEquals((Object)"stuff", (Object)response.getOutboundProperty("other"));
    }

    private void checkPayLoad(String payload) {
        Assert.assertNotNull((String)"payload is null", (Object)payload);
        Assert.assertTrue((String)("payload does not contain 'PreviousClose': " + payload), (boolean)payload.contains("PreviousClose"));
    }
}

