/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.message;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class MessageVersionCompatibilityTestCase
extends AbstractServiceAndFlowTestCase {
    private final int TIMEOUT = 5000;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/messaging/message-version-compatibility-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/messaging/message-version-compatibility-flow.xml"});
    }

    public MessageVersionCompatibilityTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testOldToOld() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://in1", (Object)"test", null);
        MuleMessage reply = client.request("vm://out1", 5000L);
        Assert.assertNotNull((Object)reply);
        Assert.assertEquals((Object)"test", (Object)reply.getPayload());
    }

    @Test
    public void testOldToNew() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://in2", (Object)"test", null);
        MuleMessage reply = client.request("vm://out2", 5000L);
        Assert.assertNotNull((Object)reply);
        Assert.assertEquals((Object)"test", (Object)reply.getPayload());
    }

    @Test
    public void testNewToOld() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://in3", (Object)"test", null);
        MuleMessage reply = client.request("vm://out3", 5000L);
        Assert.assertNull((Object)reply);
    }

    @Test
    public void testNewToNew() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://in4", (Object)"test", null);
        MuleMessage reply = client.request("vm://out4", 5000L);
        Assert.assertNotNull((Object)reply);
        Assert.assertEquals((Object)"test", (Object)reply.getPayload());
    }
}

