/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.http;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.transport.ssl.DefaultTlsContextFactory;
import org.mule.transport.ssl.api.TlsContextFactory;
import org.mule.util.ClassUtils;
import org.mule.util.IOUtils;

public class HttpListenerStaticResourcesTestCase
extends FunctionalTestCase {
    public static final String INDEX_HTML_CONTENT = "Test index.html";
    public static final String MAIN_HTML_CONTENT = "Test main.html";
    public static final String TESTING_ROOT_FOLDER_SYSTEM_PROPERTY = "test.root";
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");
    @Rule
    public DynamicPort port2 = new DynamicPort("port2");
    @Rule
    public DynamicPort port3 = new DynamicPort("port3");
    @Rule
    public SystemProperty testRoot = new SystemProperty("test.root", ClassUtils.getClassPathRoot(HttpListenerStaticResourcesTestCase.class).getPath());
    private int responseCode;
    private String payload;
    private MuleMessage response;
    private DefaultTlsContextFactory tlsContextFactory;

    protected String getConfigFile() {
        return "http-listener-static-resource-test.xml";
    }

    @Before
    public void setup() throws IOException {
        this.tlsContextFactory = new DefaultTlsContextFactory();
        this.tlsContextFactory.setTrustStorePath("trustStore");
        this.tlsContextFactory.setTrustStorePassword("mulepassword");
    }

    @Test
    public void httpUrlWithoutExplicitResourceShouldReturnDefaultDocument() throws Exception {
        String url = String.format("http://localhost:%d/static", this.port1.getNumber());
        this.executeRequest(url, true);
        Assert.assertThat((Object)HttpConstants.HttpStatus.OK.getStatusCode(), (Matcher)Is.is((Object)this.responseCode));
        Assert.assertThat((Object)this.payload, (Matcher)Is.is((Object)INDEX_HTML_CONTENT));
    }

    @Test
    public void httpUrlRequestingExplicitResourceShouldReturnResource() throws Exception {
        String url = String.format("http://localhost:%d/static/main.html", this.port1.getNumber());
        this.executeRequest(url, true);
        Assert.assertThat((Object)HttpConstants.HttpStatus.OK.getStatusCode(), (Matcher)Is.is((Object)this.responseCode));
        Assert.assertThat((Object)this.payload, (Matcher)Is.is((Object)MAIN_HTML_CONTENT));
    }

    @Test
    public void httpUrlRequestingNonexistentResourceShouldReturnNotFoundStatus() throws Exception {
        String url = String.format("http://localhost:%d/static/foo.html", this.port1.getNumber());
        this.executeRequest(url, true);
        Assert.assertThat((Object)HttpConstants.HttpStatus.NOT_FOUND.getStatusCode(), (Matcher)Is.is((Object)this.responseCode));
    }

    @Test
    public void contentTypeForDefaultResourceShouldBeTextHtml() throws Exception {
        String url = String.format("http://localhost:%d/static", this.port1.getNumber());
        this.executeRequest(url, true);
        Assert.assertThat((Object)HttpConstants.HttpStatus.OK.getStatusCode(), (Matcher)Is.is((Object)this.responseCode));
        this.assertResponseContentType("text/html");
    }

    @Test
    public void contentTypeShouldBeDetermintedFromResource() throws Exception {
        String url = String.format("http://localhost:%d/static/image.gif", this.port1.getNumber());
        this.executeRequest(url, true);
        Assert.assertThat((Object)HttpConstants.HttpStatus.OK.getStatusCode(), (Matcher)Is.is((Object)this.responseCode));
        this.assertResponseContentType("image/gif");
    }

    @Test
    public void explicitMimeTypeConfigurationShouldOverrideDefaults() throws Exception {
        String url = String.format("http://localhost:%d/static/image.png", this.port1.getNumber());
        this.executeRequest(url, true);
        Assert.assertThat((Object)HttpConstants.HttpStatus.OK.getStatusCode(), (Matcher)Is.is((Object)this.responseCode));
        this.assertResponseContentType("image/png");
    }

    @Test
    public void httpsUrlWithoutExplicitResourceShouldReturnDefaultDocument() throws Exception {
        String url = String.format("https://localhost:%d/static", this.port2.getNumber());
        this.executeRequest(url, true);
        Assert.assertThat((Object)HttpConstants.HttpStatus.OK.getStatusCode(), (Matcher)Is.is((Object)this.responseCode));
        Assert.assertThat((Object)this.payload, (Matcher)Is.is((Object)INDEX_HTML_CONTENT));
    }

    @Test
    public void httpsUrlRequestingExplicitResourceShouldReturnResource() throws Exception {
        String url = String.format("https://localhost:%d/static/main.html", this.port2.getNumber());
        this.executeRequest(url, true);
        Assert.assertThat((Object)HttpConstants.HttpStatus.OK.getStatusCode(), (Matcher)Is.is((Object)this.responseCode));
        Assert.assertThat((Object)this.payload, (Matcher)Is.is((Object)MAIN_HTML_CONTENT));
    }

    @Test
    public void httpsUrlRequestingNonexistentResourceShouldReturnNotFoundStatus() throws Exception {
        String url = String.format("https://localhost:%d/static/foo.html", this.port2.getNumber());
        this.executeRequest(url, true);
        Assert.assertThat((Object)HttpConstants.HttpStatus.NOT_FOUND.getStatusCode(), (Matcher)Is.is((Object)this.responseCode));
    }

    private void assertResponseContentType(String contentType) {
        Assert.assertThat((Object)contentType, (Matcher)Is.is((Object)((String)this.response.getInboundProperty("Content-Type".toLowerCase()))));
    }

    @Test
    public void testFlowBindingOnSamePort() throws Exception {
        String url = String.format("http://localhost:%d/echo", this.port1.getNumber());
        this.executeRequest(url, true);
        Assert.assertThat((Object)HttpConstants.HttpStatus.OK.getStatusCode(), (Matcher)Is.is((Object)this.responseCode));
        url = String.format("https://localhost:%d/echo", this.port2.getNumber());
        this.executeRequest(url, true);
        Assert.assertThat((Object)HttpConstants.HttpStatus.OK.getStatusCode(), (Matcher)Is.is((Object)this.responseCode));
    }

    @Test
    public void httpUrlWithRootAddressShouldReturnDefaultDocument() throws Exception {
        String url = String.format("http://localhost:%d/", this.port3.getNumber());
        this.executeRequest(url, false);
        Assert.assertThat((Object)HttpConstants.HttpStatus.OK.getStatusCode(), (Matcher)Is.is((Object)this.responseCode));
        Assert.assertThat((Object)this.response.getPayloadAsString(), (Matcher)Is.is((Object)INDEX_HTML_CONTENT));
    }

    @Test
    public void httpUrlExplicitResourceInRootPathShouldReturnResource() throws Exception {
        String url = String.format("http://localhost:%d/index.html", this.port3.getNumber());
        this.executeRequest(url, false);
        Assert.assertThat((Object)HttpConstants.HttpStatus.OK.getStatusCode(), (Matcher)Is.is((Object)this.responseCode));
        Assert.assertThat((Object)this.payload, (Matcher)Is.is((Object)INDEX_HTML_CONTENT));
    }

    @Test
    public void onlyServeFilesWithinBasePath() throws Exception {
        String url = String.format("http://localhost:%d/static/../http-listener-static-resource-test.xml", this.port1.getNumber());
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpGet request = new HttpGet(url);
        HttpResponse response = httpclient.execute((HttpUriRequest)request);
        Assert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Is.is((Object)HttpConstants.HttpStatus.NOT_FOUND.getStatusCode()));
        Assert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)Is.is((Object)"The file: /../http-listener-static-resource-test.xml  was not found.."));
    }

    private void executeRequest(String url, boolean followRedirects) throws Exception {
        HttpRequestOptionsBuilder optionsBuilder = HttpRequestOptionsBuilder.newOptions().disableStatusCodeValidation();
        if (!followRedirects) {
            optionsBuilder.disableFollowsRedirect();
        }
        if (url.startsWith(HttpConstants.Protocols.HTTPS.getScheme())) {
            optionsBuilder.tlsContextFactory((TlsContextFactory)this.tlsContextFactory);
        }
        this.response = muleContext.getClient().send(url, this.getTestMuleMessage(), (OperationOptions)optionsBuilder.build());
        this.responseCode = (Integer)this.response.getInboundProperty("http.status");
        this.payload = this.response.getPayloadAsString();
    }
}

