/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.filter;

import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.tck.junit4.FunctionalTestCase;

public class RegexFilterTestCase
extends FunctionalTestCase {
    Map<String, String> payloadMap;

    protected String getConfigFile() {
        return "org/mule/test/integration/filter/regex-test.xml";
    }

    @Before
    public void setUp() {
        this.payloadMap = new HashMap<String, String>();
        this.payloadMap.put("goodValue", "code with the mules");
        this.payloadMap.put("wrongValue", "code with the zebras");
    }

    @Test
    public void matchesUsingDefaultPayload() throws Exception {
        MuleEvent event = this.runFlow("default-payload-value", "run with the mules");
        Assert.assertThat((Object)event, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void notMatchesUsingDefaultPayload() throws Exception {
        MuleEvent event = this.runFlow("default-payload-value", "run with the zebras");
        Assert.assertThat((Object)event, (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void matchesConfiguringValue() throws Exception {
        MuleEvent event = this.runFlow("matches-configuring-value", this.payloadMap);
        Assert.assertThat((Object)event, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void notMatchesConfiguringValue() throws Exception {
        MuleEvent event = this.runFlow("not-matches-configuring-value", this.payloadMap);
        Assert.assertThat((Object)event, (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void notMatchesConfiguringNonStringValue() throws Exception {
        this.payloadMap.remove("goodValue");
        MuleEvent event = this.runFlow("not-matches-configuring-non-string-value", this.payloadMap);
        Assert.assertThat((Object)event, (Matcher)Is.is((Matcher)IsNull.nullValue()));
    }

    @Test
    public void matchesConfiguringPlainTextValue() throws Exception {
        MuleEvent event = this.runFlow("matches-configuring-plain-text-value");
        Assert.assertThat((Object)event, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }
}

