/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.lang.mutable.MutableInt;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.OperationOptions;
import org.mule.api.context.notification.ExceptionNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.api.processor.MessageProcessor;
import org.mule.context.notification.ExceptionNotification;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.CharSetUtils;
import org.mule.util.concurrent.Latch;

public class RollbackExceptionStrategyTestCase
extends AbstractServiceAndFlowTestCase {
    public static final int TIMEOUT = 5000;
    public static final String JSON_REQUEST = "{\"userId\":\"15\"}";
    public static final int MAX_REDELIVERY = 4;
    public static final int EXPECTED_DELIVERED_TIMES = 5;
    public static final int SHORT_MAX_REDELIVERY = 2;
    public static final int EXPECTED_SHORT_DELIVERED_TIMES = 3;
    public static final String MESSAGE = "some message";
    public static final String MESSAGE_EXPECTED = "some message consumed successfully";
    @Rule
    public DynamicPort dynamicPort1 = new DynamicPort("port1");
    @Rule
    public DynamicPort dynamicPort2 = new DynamicPort("port2");

    public RollbackExceptionStrategyTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
        System.setProperty("maxRedelivery", String.valueOf(4));
        System.setProperty("shortMaxRedelivery", String.valueOf(2));
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/exceptions/rollback-exception-strategy-use-case-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/exceptions/rollback-exception-strategy-use-case-flow.xml"});
    }

    @Test
    public void testAlwaysRollback() throws Exception {
        final CountDownLatch latch = new CountDownLatch(5);
        LocalMuleClient client = muleContext.getClient();
        muleContext.registerListener((ServerNotificationListener)new ExceptionNotificationListener<ExceptionNotification>(){

            public void onNotification(ExceptionNotification notification) {
                latch.countDown();
            }
        });
        client.dispatch("vm://in", (Object)MESSAGE, null);
        if (!latch.await(5000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"message should have been delivered at least 5 times");
        }
    }

    @Test
    @Ignore(value="MULE-6926: flaky test")
    public void testAlwaysRollbackJmsNoTransaction() throws Exception {
        final CountDownLatch latch = new CountDownLatch(5);
        LocalMuleClient client = muleContext.getClient();
        muleContext.registerListener((ServerNotificationListener)new ExceptionNotificationListener<ExceptionNotification>(){

            public void onNotification(ExceptionNotification notification) {
                latch.countDown();
            }
        });
        client.dispatch("jms://in?connector=activeMq", (Object)MESSAGE, null);
        if (!latch.await(5000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"message should have been delivered at least 5 times");
        }
    }

    @Test
    @Ignore(value="MULE-6926: flaky test")
    public void testRedeliveryExhaustedTransactional() throws Exception {
        final CountDownLatch latch = new CountDownLatch(5);
        final MutableInt deliveredTimes = new MutableInt(0);
        LocalMuleClient client = muleContext.getClient();
        muleContext.registerListener((ServerNotificationListener)new ExceptionNotificationListener<ExceptionNotification>(){

            public void onNotification(ExceptionNotification notification) {
                deliveredTimes.increment();
                latch.countDown();
            }
        });
        client.dispatch("jms://in2?connector=activeMq", (Object)MESSAGE, null);
        if (!latch.await(5000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"message should have been delivered at least 5 times");
        }
        Assert.assertThat((Object)deliveredTimes.intValue(), (Matcher)Is.is((Object)5));
        MuleMessage dlqMessage = client.request("jms://dlq?connector=activeMq", 5000L);
        Assert.assertThat((Object)dlqMessage, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)dlqMessage.getPayloadAsString(), (Matcher)Is.is((Object)MESSAGE_EXPECTED));
    }

    @Test
    public void testRollbackWithComponent() throws Exception {
        final CountDownLatch latch = new CountDownLatch(5);
        LocalMuleClient client = muleContext.getClient();
        muleContext.registerListener((ServerNotificationListener)new ExceptionNotificationListener<ExceptionNotification>(){

            public void onNotification(ExceptionNotification notification) {
                latch.countDown();
            }
        });
        client.dispatch("vm://in5", (Object)MESSAGE, null);
        if (!latch.await(5000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"message should have been delivered at least 5 times");
        }
        MuleMessage result = client.send("vm://in5", (Object)MESSAGE, null, 5000L);
        Assert.assertThat((Object)result, (Matcher)Is.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testFullyDefinedRollbackExceptionStrategyWithComponent() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = null;
        for (int i = 1; i <= 3; ++i) {
            result = client.send("vm://in6", (Object)MESSAGE, null, 5000L);
            Assert.assertThat((Object)result, (Matcher)IsNull.notNullValue());
            Assert.assertThat((Object)result.getExceptionPayload(), (Matcher)IsNull.notNullValue());
            Assert.assertThat((Object)result.getPayloadAsString(), (Matcher)Is.is((Object)"some message apt1 apt2 apt3"));
        }
        result = client.send("vm://in6", (Object)MESSAGE, null, 5000L);
        Assert.assertThat((Object)result, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)result.getPayloadAsString(), (Matcher)Is.is((Object)"some message apt4 groovified"));
    }

    @Test
    public void testRedeliveryExhaustedNoTransaction() throws Exception {
        final CountDownLatch latch = new CountDownLatch(5);
        final MutableInt deliveredTimes = new MutableInt(0);
        LocalMuleClient client = muleContext.getClient();
        muleContext.registerListener((ServerNotificationListener)new ExceptionNotificationListener<ExceptionNotification>(){

            public void onNotification(ExceptionNotification notification) {
                deliveredTimes.increment();
                latch.countDown();
            }
        });
        client.dispatch("jms://in3?connector=activeMq", (Object)MESSAGE, null);
        if (!latch.await(5000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"message should have been delivered at least 5 times");
        }
        Assert.assertThat((Object)deliveredTimes.intValue(), (Matcher)Is.is((Object)5));
        MuleMessage dlqMessage = client.request("jms://dlq?connector=activeMq", 5000L);
        Assert.assertThat((Object)dlqMessage, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)dlqMessage.getPayloadAsString(), (Matcher)Is.is((Object)MESSAGE_EXPECTED));
    }

    @Test
    public void testHttpAlwaysRollbackUsingMuleClient() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send(String.format("http://localhost:%s", this.dynamicPort1.getNumber()), RollbackExceptionStrategyTestCase.getTestMuleMessage((Object)JSON_REQUEST), (OperationOptions)((HttpRequestOptionsBuilder)HttpRequestOptionsBuilder.newOptions().disableStatusCodeValidation().responseTimeout(5000L)).build());
        Assert.assertThat((Object)response.getInboundProperty("http.status"), (Matcher)Is.is((Object)500));
    }

    @Test
    public void testHttpAlwaysRollbackUsingHttpClient() throws Exception {
        HttpClient httpClient = new HttpClient();
        GetMethod getMethod = new GetMethod(String.format("http://localhost:%s", this.dynamicPort1.getNumber()));
        int status = httpClient.executeMethod((HttpMethod)getMethod);
        Assert.assertThat((Object)status, (Matcher)Is.is((Object)500));
        getMethod.releaseConnection();
    }

    @Test
    public void testHttpRedeliveryExhaustedRollbackUsingMuleClient() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = null;
        HttpRequestOptions httpRequestOptions = ((HttpRequestOptionsBuilder)HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).disableStatusCodeValidation().responseTimeout(5000L)).build();
        for (int i = 1; i <= 3; ++i) {
            response = client.send(String.format("http://localhost:%s", this.dynamicPort2.getNumber()), RollbackExceptionStrategyTestCase.getTestMuleMessage((Object)MESSAGE), (OperationOptions)httpRequestOptions);
            Assert.assertThat((Object)response.getInboundProperty("http.status"), (Matcher)Is.is((Object)500));
        }
        response = client.send(String.format("http://localhost:%s", this.dynamicPort2.getNumber()), RollbackExceptionStrategyTestCase.getTestMuleMessage((Object)MESSAGE), (OperationOptions)httpRequestOptions);
        Assert.assertThat((Object)response.getInboundProperty("http.status"), (Matcher)Is.is((Object)200));
        Assert.assertThat((Object)response.getExceptionPayload(), (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)Is.is((Object)MESSAGE_EXPECTED));
    }

    @Test
    public void testHttpRedeliveryExhaustedRollbackUsingHttpClient() throws Exception {
        int status;
        HttpClient httpClient = new HttpClient();
        PostMethod postMethod = new PostMethod(String.format("http://localhost:%s", this.dynamicPort2.getNumber()));
        postMethod.setRequestEntity((RequestEntity)new StringRequestEntity(MESSAGE, "html/text", CharSetUtils.defaultCharsetName()));
        for (int i = 1; i <= 3; ++i) {
            status = httpClient.executeMethod((HttpMethod)postMethod);
            Assert.assertThat((Object)status, (Matcher)Is.is((Object)500));
            postMethod.releaseConnection();
        }
        status = httpClient.executeMethod((HttpMethod)postMethod);
        Assert.assertThat((Object)status, (Matcher)Is.is((Object)200));
        Assert.assertThat((Object)postMethod.getResponseBodyAsString(), (Matcher)Is.is((Object)MESSAGE_EXPECTED));
        postMethod.releaseConnection();
    }

    @Test
    public void testFullyDefinedRollbackExceptionStrategy() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = null;
        for (int i = 1; i <= 3; ++i) {
            result = client.send("vm://in2", (Object)MESSAGE, null, 5000L);
            Assert.assertThat((Object)result, (Matcher)IsNull.notNullValue());
            Assert.assertThat((Object)result.getExceptionPayload(), (Matcher)IsNull.notNullValue());
            Assert.assertThat((Object)result.getPayloadAsString(), (Matcher)Is.is((Object)"some message apt1 apt2 apt3"));
        }
        result = client.send("vm://in2", (Object)MESSAGE, null, 5000L);
        Assert.assertThat((Object)result, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)result.getPayloadAsString(), (Matcher)Is.is((Object)"some message apt4 apt5"));
    }

    @Test
    @Ignore(value="MULE-6926: flaky test")
    public void testRedeliveryPolicyRedefinition() throws Exception {
        final CountDownLatch latch = new CountDownLatch(5);
        final MutableInt deliveredTimes = new MutableInt(0);
        LocalMuleClient client = muleContext.getClient();
        muleContext.registerListener((ServerNotificationListener)new ExceptionNotificationListener<ExceptionNotification>(){

            public void onNotification(ExceptionNotification notification) {
                deliveredTimes.increment();
                latch.countDown();
            }
        });
        client.dispatch("vm://in3", (Object)MESSAGE, null);
        if (!latch.await(5000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"message should have been delivered at least 5 times");
        }
        Assert.assertThat((Object)deliveredTimes.intValue(), (Matcher)Is.is((Object)5));
    }

    @Test
    @Ignore(value="MULE-6926: flaky test")
    public void testInboundEndpointMaxRedeliveryTakesPrecendence() throws Exception {
        final CountDownLatch latch = new CountDownLatch(5);
        final MutableInt deliveredTimes = new MutableInt(0);
        LocalMuleClient client = muleContext.getClient();
        muleContext.registerListener((ServerNotificationListener)new ExceptionNotificationListener<ExceptionNotification>(){

            public void onNotification(ExceptionNotification notification) {
                deliveredTimes.increment();
                latch.countDown();
            }
        });
        client.dispatch("vm://in4", (Object)MESSAGE, null);
        if (!latch.await(5000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"message should have been delivered at least 5 times");
        }
        Assert.assertThat((Object)deliveredTimes.intValue(), (Matcher)Is.is((Object)5));
    }

    @Test
    public void testRollbackExceptionStrategyCatchMessageRedeliveryDespiteChoiceConfiguration() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://in7", (Object)MESSAGE, null);
        if (!CallMessageProcessor.latch.await(5000L, TimeUnit.MILLISECONDS)) {
            Assert.fail((String)"custom message processor wasn't call");
        }
    }

    public static class CallMessageProcessor
    implements MessageProcessor {
        public static Latch latch = new Latch();

        public MuleEvent process(MuleEvent event) throws MuleException {
            latch.release();
            return event;
        }
    }
}

