/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.exception.AbstractExceptionListener;
import org.mule.exception.ChoiceMessagingExceptionStrategy;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transport.NullPayload;

public class ReferenceExceptionStrategyTestCase
extends FunctionalTestCase {
    public static final int TIMEOUT = 5000;
    public static final String JSON_RESPONSE = "{\"errorMessage\":\"error processing news\",\"userId\":15,\"title\":\"News title\"}";
    public static final String JSON_REQUEST = "{\"userId\":\"15\"}";

    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/reference-flow-exception-strategy.xml";
    }

    @Test
    public void testFlowUsingGlobalExceptionStrategy() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://in", (Object)JSON_REQUEST, null, 5000L);
        Assert.assertThat((Object)response, (Matcher)IsNull.notNullValue());
        ObjectMapper mapper = new ObjectMapper();
        JsonNode actualJsonNode = mapper.readTree(response.getPayloadAsString());
        JsonNode expectedJsonNode = mapper.readTree(JSON_RESPONSE);
        Assert.assertThat((Object)actualJsonNode, (Matcher)Is.is((Object)expectedJsonNode));
    }

    @Test
    public void testFlowUsingConfiguredExceptionStrategy() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://in2", (Object)JSON_REQUEST, null, 5000L);
        Assert.assertThat((Object)response, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)((NullPayload)response.getPayload()), (Matcher)Is.is((Object)NullPayload.getInstance()));
        Assert.assertThat((Object)response.getExceptionPayload(), (Matcher)IsNull.notNullValue());
    }

    @Test
    public void testTwoFlowsReferencingSameExceptionStrategyGetDifferentInstances() {
        MessagingExceptionHandler firstExceptionStrategy = muleContext.getRegistry().lookupFlowConstruct("otherFlowWithSameReferencedExceptionStrategy").getExceptionListener();
        MessagingExceptionHandler secondExceptionStrategy = muleContext.getRegistry().lookupFlowConstruct("referenceExceptionStrategyFlow").getExceptionListener();
        Assert.assertThat((Object)firstExceptionStrategy, (Matcher)IsNot.not((Object)secondExceptionStrategy));
    }

    @Test
    public void testTwoFlowsReferencingDifferentExceptionStrategy() {
        MessagingExceptionHandler firstExceptionStrategy = muleContext.getRegistry().lookupFlowConstruct("otherFlowWithSameReferencedExceptionStrategy").getExceptionListener();
        MessagingExceptionHandler secondExceptionStrategy = muleContext.getRegistry().lookupFlowConstruct("anotherFlowUsingDifferentExceptionStrategy").getExceptionListener();
        Assert.assertThat((Object)firstExceptionStrategy, (Matcher)IsNot.not((Object)secondExceptionStrategy));
        Assert.assertThat((Object)((AbstractExceptionListener)firstExceptionStrategy).getMessageProcessors().size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)secondExceptionStrategy, (Matcher)IsInstanceOf.instanceOf(ChoiceMessagingExceptionStrategy.class));
    }
}

