/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

@RunWith(value=Parameterized.class)
public class InvalidFilterEvaluatorUsageTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort port = new DynamicPort("port1");
    @Rule
    public SystemProperty expression;
    private final String evaluatorName;

    public InvalidFilterEvaluatorUsageTestCase(String evaluatorName) throws Throwable {
        this.evaluatorName = evaluatorName;
        this.expression = new SystemProperty("expression", evaluatorName + ":dummy expression");
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return Arrays.asList({"payload-type"}, {"exception-type"}, {"regex"}, {"wildcard"});
    }

    protected String getConfigFile() {
        return "invalid-filter-evaluator-usage-config.xml";
    }

    @Test
    public void producesClearErrorMessage() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HttpRequestOptions httpRequestOptions = HttpRequestOptionsBuilder.newOptions().disableStatusCodeValidation().build();
        MuleMessage response = client.send("http://localhost:" + this.port.getNumber(), this.getTestMuleMessage(), (OperationOptions)httpRequestOptions);
        Assert.assertTrue((boolean)response.getPayloadAsString().contains(this.evaluatorName));
        Assert.assertTrue((boolean)response.getPayloadAsString().contains("java.lang.UnsupportedOperationException"));
    }
}

