/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class ExceptionStrategyMessagePropertiesTestCase
extends AbstractServiceAndFlowTestCase {
    private final int numMessages = 100;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/exceptions/exception-strategy-message-properties-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/exceptions/exception-strategy-message-properties-flow.xml"});
    }

    public ExceptionStrategyMessagePropertiesTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testException() throws Exception {
        Tester tester1 = new Tester();
        Tester tester2 = new Tester();
        tester1.start();
        tester2.start();
        LocalMuleClient client = muleContext.getClient();
        for (int i = 0; i < 100; ++i) {
            MuleMessage msg = client.request("vm://error", 5000L);
            Assert.assertNotNull((Object)msg);
            Assert.assertEquals((Object)"bar", (Object)msg.getInboundProperty("foo"));
        }
    }

    class Tester
    extends Thread {
        Tester() {
        }

        @Override
        public void run() {
            try {
                LocalMuleClient client = muleContext.getClient();
                HashMap<String, String> props = new HashMap<String, String>();
                props.put("foo", "bar");
                for (int i = 0; i < 100; ++i) {
                    client.dispatch("vm://in", (Object)"test", props);
                }
            }
            catch (Exception e) {
                Assert.fail((String)e.getMessage());
            }
        }
    }
}

