/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Lifecycle;
import org.mule.api.processor.MessageProcessor;
import org.mule.exception.TemplateMessagingExceptionStrategy;
import org.mule.tck.junit4.FunctionalTestCase;

public class ExceptionStrategyLifecycleTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/default-exception-strategy-lifecycle.xml";
    }

    @Test
    public void testLifecycle() throws Exception {
        FlowConstruct flowA = this.getFlowConstruct("flowA");
        FlowConstruct flowB = this.getFlowConstruct("flowB");
        TemplateMessagingExceptionStrategy flowAExceptionStrategy = (TemplateMessagingExceptionStrategy)flowA.getExceptionListener();
        TemplateMessagingExceptionStrategy flowBExceptionStrategy = (TemplateMessagingExceptionStrategy)flowB.getExceptionListener();
        LifecycleCheckerMessageProcessor lifecycleCheckerMessageProcessorFlowA = (LifecycleCheckerMessageProcessor)flowAExceptionStrategy.getMessageProcessors().get(0);
        LifecycleCheckerMessageProcessor lifecycleCheckerMessageProcessorFlowB = (LifecycleCheckerMessageProcessor)flowBExceptionStrategy.getMessageProcessors().get(0);
        Assert.assertThat((Object)lifecycleCheckerMessageProcessorFlowA.isInitialized(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)lifecycleCheckerMessageProcessorFlowB.isInitialized(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)flowAExceptionStrategy.isInitialised(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)flowBExceptionStrategy.isInitialised(), (Matcher)Is.is((Object)true));
        ((Lifecycle)flowA).stop();
        Assert.assertThat((Object)lifecycleCheckerMessageProcessorFlowA.isStopped(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)lifecycleCheckerMessageProcessorFlowB.isStopped(), (Matcher)Is.is((Object)false));
        FlowConstruct flowC = this.getFlowConstruct("flowC");
        FlowConstruct flowD = this.getFlowConstruct("flowD");
        TemplateMessagingExceptionStrategy flowCExceptionStrategy = (TemplateMessagingExceptionStrategy)flowC.getExceptionListener();
        TemplateMessagingExceptionStrategy flowDExceptionStrategy = (TemplateMessagingExceptionStrategy)flowD.getExceptionListener();
        LifecycleCheckerMessageProcessor lifecycleCheckerMessageProcessorFlowC = (LifecycleCheckerMessageProcessor)flowCExceptionStrategy.getMessageProcessors().get(0);
        LifecycleCheckerMessageProcessor lifecycleCheckerMessageProcessorFlowD = (LifecycleCheckerMessageProcessor)flowDExceptionStrategy.getMessageProcessors().get(0);
        Assert.assertThat((Object)lifecycleCheckerMessageProcessorFlowC.isInitialized(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)lifecycleCheckerMessageProcessorFlowD.isInitialized(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)flowCExceptionStrategy.isInitialised(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)flowDExceptionStrategy.isInitialised(), (Matcher)Is.is((Object)true));
        ((Lifecycle)flowC).stop();
        Assert.assertThat((Object)lifecycleCheckerMessageProcessorFlowC.isStopped(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)lifecycleCheckerMessageProcessorFlowD.isStopped(), (Matcher)Is.is((Object)false));
    }

    public static class LifecycleCheckerMessageProcessor
    implements MessageProcessor,
    Lifecycle {
        private boolean initialized;
        private boolean disposed;
        private boolean started;
        private boolean stopped;

        public MuleEvent process(MuleEvent event) throws MuleException {
            return event;
        }

        public void dispose() {
            this.disposed = true;
        }

        public void initialise() throws InitialisationException {
            this.initialized = true;
        }

        public void start() throws MuleException {
            this.started = true;
        }

        public void stop() throws MuleException {
            this.stopped = true;
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        public boolean isDisposed() {
            return this.disposed;
        }

        public boolean isStarted() {
            return this.started;
        }

        public boolean isStopped() {
            return this.stopped;
        }
    }
}

