/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.routing.filter.Filter;
import org.mule.api.routing.filter.FilterUnacceptedException;
import org.mule.api.transport.DispatchException;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.ExceptionUtils;

public class ExceptionStrategyFilterMule5342TestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/exception-strategy-filter-mule-5342.xml";
    }

    @Test
    public void exceptionThrownFromMessageFilterIsHandledByExceptionHandler() throws Exception {
        try {
            LocalMuleClient client = muleContext.getClient();
            client.send("vm://in", (Object)"Test Message", null);
        }
        catch (DispatchException e) {
            this.assertThatRootCauseIsFilterUnacceptedException(e);
        }
    }

    private void assertThatRootCauseIsFilterUnacceptedException(DispatchException e) {
        int index = ExceptionUtils.indexOfThrowable((Throwable)e, FilterUnacceptedException.class);
        Assert.assertTrue((index > -1 ? 1 : 0) != 0);
    }

    public static class FalseFilter
    implements Filter {
        public boolean accept(MuleMessage message) {
            return false;
        }
    }
}

