/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.MuleClient;
import org.mule.api.context.notification.ExceptionStrategyNotificationListener;
import org.mule.api.context.notification.ServerNotification;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.ExceptionStrategyNotification;
import org.mule.message.ExceptionMessage;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;

public class ExceptionListenerTestCase
extends AbstractServiceAndFlowTestCase {
    private static final int TIMEOUT_MILLIS = 5000;
    private static final int POLL_DELAY_MILLIS = 100;
    private MuleClient client;
    private ServerNotification exceptionStrategyStartNotification;
    private ServerNotification exceptionStrategyEndNotification;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/exceptions/exception-listener-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/exceptions/exception-listener-config-flow.xml"});
    }

    public ExceptionListenerTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.client = muleContext.getClient();
        this.exceptionStrategyStartNotification = null;
        this.exceptionStrategyEndNotification = null;
        muleContext.getNotificationManager().addListener((ServerNotificationListener)new ExceptionStrategyNotificationListener<ExceptionStrategyNotification>(){

            public void onNotification(ExceptionStrategyNotification notification) {
                if (notification.getAction() == 2001) {
                    ExceptionListenerTestCase.this.exceptionStrategyStartNotification = (ServerNotification)notification;
                } else if (notification.getAction() == 2002) {
                    ExceptionListenerTestCase.this.exceptionStrategyEndNotification = (ServerNotification)notification;
                }
            }
        });
    }

    @Test
    public void testExceptionStrategyFromComponent() throws Exception {
        this.assertQueueIsEmpty("vm://error.queue");
        this.client.send("vm://component.in", (Object)"test", null);
        this.assertQueueIsEmpty("vm://component.out");
        MuleMessage message = this.client.request("vm://error.queue", 2000L);
        Assert.assertNotNull((Object)message);
        Object payload = message.getPayload();
        Assert.assertTrue((boolean)(payload instanceof ExceptionMessage));
        this.assertNotificationsArrived();
        this.assertNotificationsHaveMatchingResourceIds();
    }

    private void assertNotificationsHaveMatchingResourceIds() {
        Assert.assertThat((Object)this.exceptionStrategyStartNotification.getResourceIdentifier(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)this.exceptionStrategyStartNotification.getResourceIdentifier(), (Matcher)CoreMatchers.is((Object)"mycomponent"));
        Assert.assertThat((Object)this.exceptionStrategyStartNotification.getResourceIdentifier(), (Matcher)CoreMatchers.is((Object)this.exceptionStrategyEndNotification.getResourceIdentifier()));
    }

    private void assertNotificationsArrived() {
        PollingProber prober = new PollingProber(5000L, 100L);
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() throws Exception {
                Assert.assertThat((Object)ExceptionListenerTestCase.this.exceptionStrategyStartNotification, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
                Assert.assertThat((Object)ExceptionListenerTestCase.this.exceptionStrategyEndNotification, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
                return true;
            }

            public String describeFailure() {
                return "Did not get exception strategy notifications";
            }
        });
    }

    private void assertQueueIsEmpty(String queueName) throws MuleException {
        MuleMessage message = this.client.request(queueName, 2000L);
        Assert.assertNull((Object)message);
    }
}

