/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import java.util.HashSet;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.exception.MessagingExceptionHandler;
import org.mule.api.service.Service;
import org.mule.exception.CatchMessagingExceptionStrategy;
import org.mule.exception.DefaultMessagingExceptionStrategy;
import org.mule.tck.junit4.FunctionalTestCase;

public class DefaultExceptionStrategyTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/default-exception-strategy.xml";
    }

    @Test
    public void testFlowAndServiceUseProperExceptionStrategy() {
        HashSet<MessagingExceptionHandler> usedExceptionStrategies = new HashSet<MessagingExceptionHandler>();
        Service serviceNoExceptionStrategy = muleContext.getRegistry().lookupService("serviceNoExceptionStrategy");
        MessagingExceptionHandler serviceNoExceptionStrategyExceptionListener = serviceNoExceptionStrategy.getExceptionListener();
        Assert.assertThat((Object)serviceNoExceptionStrategyExceptionListener, (Matcher)IsInstanceOf.instanceOf(CatchMessagingExceptionStrategy.class));
        usedExceptionStrategies.add(serviceNoExceptionStrategyExceptionListener);
        Service serviceExceptionStrategy = muleContext.getRegistry().lookupService("serviceExceptionStrategy");
        MessagingExceptionHandler serviceExceptionStrategyExceptionListener = serviceExceptionStrategy.getExceptionListener();
        Assert.assertThat((Object)serviceExceptionStrategyExceptionListener, (Matcher)IsInstanceOf.instanceOf(DefaultMessagingExceptionStrategy.class));
        Assert.assertThat((Object)usedExceptionStrategies.add(serviceExceptionStrategyExceptionListener), (Matcher)Is.is((Object)true));
        Service serviceNoExceptionStrategyInModel = muleContext.getRegistry().lookupService("serviceNoExceptionStrategyInModel");
        MessagingExceptionHandler serviceNoExceptionStrategyInModelExceptionListener = serviceNoExceptionStrategyInModel.getExceptionListener();
        Assert.assertThat((Object)serviceNoExceptionStrategyInModelExceptionListener, (Matcher)IsInstanceOf.instanceOf(CustomExceptionStrategy.class));
        Assert.assertThat((Object)usedExceptionStrategies.add(serviceNoExceptionStrategyInModelExceptionListener), (Matcher)Is.is((Object)true));
        FlowConstruct flowNoExceptionStrategy = muleContext.getRegistry().lookupFlowConstruct("flowNoExceptionStrategy");
        MessagingExceptionHandler flowNoExceptionStrategyExceptionListener = flowNoExceptionStrategy.getExceptionListener();
        Assert.assertThat((Object)flowNoExceptionStrategyExceptionListener, (Matcher)IsInstanceOf.instanceOf(CustomExceptionStrategy.class));
        Assert.assertThat((Object)usedExceptionStrategies.add(flowNoExceptionStrategyExceptionListener), (Matcher)Is.is((Object)true));
        FlowConstruct flowExceptionStrategy = muleContext.getRegistry().lookupFlowConstruct("flowExceptionStrategy");
        MessagingExceptionHandler flowExceptionStrategyExceptionListener = flowExceptionStrategy.getExceptionListener();
        Assert.assertThat((Object)flowExceptionStrategyExceptionListener, (Matcher)IsInstanceOf.instanceOf(CatchMessagingExceptionStrategy.class));
        Assert.assertThat((Object)usedExceptionStrategies.add(flowExceptionStrategyExceptionListener), (Matcher)Is.is((Object)true));
    }

    public static class CustomExceptionStrategy
    implements MessagingExceptionHandler {
        private boolean enableNotifications = true;
        private String logException = "true";

        public MuleEvent handleException(Exception exception, MuleEvent event) {
            return null;
        }

        public boolean isEnableNotifications() {
            return this.enableNotifications;
        }

        public void setEnableNotifications(boolean enableNotifications) {
            this.enableNotifications = enableNotifications;
        }

        public String getLogException() {
            return this.logException;
        }

        public void setLogException(String logException) {
            this.logException = logException;
        }
    }
}

