/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mule.api.MessagingException;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.transaction.Transaction;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.listener.ExceptionListener;
import org.mule.tck.listener.SystemExceptionListener;
import org.mule.transaction.TransactionCoordination;

public class CatchExceptionStrategyTransactionTestCase
extends AbstractServiceAndFlowTestCase {
    private static final int TIMEOUT = 5000;
    private static final int SHORT_TIMEOUT = 100;
    private static final String MESSAGE = "any message";
    private static final String SINGLE_TRANSACTION_BEHAVIOR_FLOW = "singleTransactionBehavior";
    private static final String XA_TRANSACTION_BEHAVIOR_FLOW = "xaTransactionBehavior";
    private static final String TRANSACTION_COMMIT_FAILS_FLOW = "transactionCommitFails";
    private static final String IN_2_VM_ENDPOINT = "vm://vmIn2";
    private static final String IN_3_VM_ENDPOINT = "vm://in3";
    private static final String IN_1_JMS_ENDPOINT = "jms://in1?connector=activeMq";
    private static final String IN_2_JMS_ENDPOINT = "jms://in2?connector=activeMq";
    private static final String OUT_2_JMS_ENDPOINT = "jms://out2?connector=activeMq";
    private Transaction mockTransaction = (Transaction)Mockito.mock(Transaction.class);

    public CatchExceptionStrategyTransactionTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/exceptions/catch-exception-strategy-transaction-flow.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/exceptions/catch-exception-strategy-transaction-service.xml"});
    }

    @Test
    public void singleTransactionIsCommittedOnFailure() throws Exception {
        this.getFunctionalTestComponent(SINGLE_TRANSACTION_BEHAVIOR_FLOW).setEventCallback(this.getFailureCallback());
        LocalMuleClient client = muleContext.getClient();
        ExceptionListener exceptionListener = new ExceptionListener(muleContext);
        exceptionListener.setTimeoutInMillis(5000);
        client.dispatch(IN_1_JMS_ENDPOINT, (Object)MESSAGE, null);
        exceptionListener.waitUntilAllNotificationsAreReceived();
        this.stopFlowConstruct(SINGLE_TRANSACTION_BEHAVIOR_FLOW);
        MuleMessage request = client.request(IN_1_JMS_ENDPOINT, 100L);
        Assert.assertThat((Object)request, (Matcher)IsNull.nullValue());
    }

    @Test
    public void singleTransactionIsCommittedOnFailureButCommitFails() throws Exception {
        this.getFunctionalTestComponent(SINGLE_TRANSACTION_BEHAVIOR_FLOW).setEventCallback(this.replaceTransactionWithMockAndFailComponent());
        LocalMuleClient client = muleContext.getClient();
        ExceptionListener exceptionListener = new ExceptionListener(muleContext);
        exceptionListener.setTimeoutInMillis(5000);
        SystemExceptionListener systemExceptionListener = new SystemExceptionListener(muleContext).setTimeoutInMillis(5000);
        client.dispatch(IN_1_JMS_ENDPOINT, (Object)MESSAGE, null);
        exceptionListener.waitUntilAllNotificationsAreReceived();
        this.stopFlowConstruct(SINGLE_TRANSACTION_BEHAVIOR_FLOW);
        systemExceptionListener.waitUntilAllNotificationsAreReceived();
        MuleMessage request = client.request(IN_1_JMS_ENDPOINT, 100L);
        Assert.assertThat((Object)request, (Matcher)IsNull.notNullValue());
    }

    @Test
    public void xaTransactionIsCommittedOnFailure() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        ExceptionListener exceptionListener = new ExceptionListener(muleContext);
        exceptionListener.setTimeoutInMillis(5000);
        client.dispatch(IN_2_JMS_ENDPOINT, (Object)MESSAGE, null);
        exceptionListener.waitUntilAllNotificationsAreReceived();
        this.stopFlowConstruct(XA_TRANSACTION_BEHAVIOR_FLOW);
        MuleMessage outMessage = client.request(OUT_2_JMS_ENDPOINT, 5000L);
        Assert.assertThat((Object)outMessage, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)outMessage.getPayloadAsString(), (Matcher)Is.is((Object)MESSAGE));
        MuleMessage inMessage = client.request(IN_2_JMS_ENDPOINT, 100L);
        Assert.assertThat((Object)inMessage, (Matcher)IsNull.nullValue());
        MuleMessage inVmMessage = client.request(IN_2_VM_ENDPOINT, 5000L);
        Assert.assertThat((Object)inVmMessage, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)inVmMessage.getPayloadAsString(), (Matcher)Is.is((Object)MESSAGE));
    }

    @Test
    public void transactionCommitFailureTriggersExceptionStrategy() throws Exception {
        this.transactionCommitFailureExecutesExceptionStrategy(this.getTestMuleMessage());
    }

    @Test
    public void transactionCommitFailureTriggersExceptionStrategyUsingFilter() throws Exception {
        Assume.assumeThat((Object)this.variant, (Matcher)Is.is((Object)AbstractServiceAndFlowTestCase.ConfigVariant.FLOW));
        MuleMessage muleMessage = this.getTestMuleMessage();
        muleMessage.setOutboundProperty("filterMessage", (Object)true);
        this.transactionCommitFailureExecutesExceptionStrategy(muleMessage);
    }

    private void transactionCommitFailureExecutesExceptionStrategy(MuleMessage muleMessage) throws Exception {
        this.getFunctionalTestComponent(TRANSACTION_COMMIT_FAILS_FLOW).setEventCallback(this.replaceTransactionWithMock());
        ExceptionListener exceptionListener = new ExceptionListener(muleContext);
        muleContext.getClient().dispatch(IN_3_VM_ENDPOINT, muleMessage);
        exceptionListener.waitUntilAllNotificationsAreReceived();
        this.stopFlowConstruct(TRANSACTION_COMMIT_FAILS_FLOW);
        exceptionListener.assertExpectedException(MessagingException.class);
    }

    @Test
    public void transactionCommitFailureWithinCatchExceptionStrategy() throws Exception {
        SystemExceptionListener systemExceptionListener = new SystemExceptionListener(muleContext);
        this.getFunctionalTestComponent(TRANSACTION_COMMIT_FAILS_FLOW).setEventCallback(this.replaceTransactionWithMockAndFailComponent());
        ExceptionListener exceptionListener = new ExceptionListener(muleContext);
        muleContext.getClient().dispatch(IN_3_VM_ENDPOINT, this.getTestMuleMessage());
        exceptionListener.waitUntilAllNotificationsAreReceived();
        this.stopFlowConstruct(TRANSACTION_COMMIT_FAILS_FLOW);
        systemExceptionListener.waitUntilAllNotificationsAreReceived();
    }

    private EventCallback replaceTransactionWithMock(final EventCallback processEventCallback) throws Exception {
        Mockito.when((Object)this.mockTransaction.supports(Matchers.anyObject(), Matchers.anyObject())).thenReturn((Object)true);
        ((Transaction)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                TransactionCoordination.getInstance().unbindTransaction(CatchExceptionStrategyTransactionTestCase.this.mockTransaction);
                throw new RuntimeException();
            }
        }).when((Object)this.mockTransaction)).commit();
        return new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                context.getCurrentTransaction().rollback();
                TransactionCoordination.getInstance().bindTransaction(CatchExceptionStrategyTransactionTestCase.this.mockTransaction);
                processEventCallback.eventReceived(context, component);
            }
        };
    }

    private EventCallback replaceTransactionWithMock() throws Exception {
        return this.replaceTransactionWithMock(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
            }
        });
    }

    private EventCallback replaceTransactionWithMockAndFailComponent() throws Exception {
        return this.replaceTransactionWithMock(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                throw new RuntimeException();
            }
        });
    }

    private EventCallback getFailureCallback() {
        return new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                throw new RuntimeException();
            }
        };
    }
}

