/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.test.integration.exceptions.AbstractExceptionStrategyTestCase;

public class AsynchronousMessagingExceptionStrategyTestCase
extends AbstractExceptionStrategyTestCase {
    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/asynch-messaging-exception-strategy.xml";
    }

    @Test
    public void testInboundTransformer() throws Exception {
        this.client.dispatch("vm://in1", (Object)"Test Message", null);
        this.latch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)this.serviceExceptionCounter.get());
        Assert.assertEquals((long)0L, (long)this.systemExceptionCounter.get());
    }

    @Test
    public void testInboundResponseTransformer() throws Exception {
        this.client.dispatch("vm://in2", (Object)"Test Message", null);
        this.latch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)0L, (long)this.serviceExceptionCounter.get());
        Assert.assertEquals((long)0L, (long)this.systemExceptionCounter.get());
    }

    @Test
    public void testOutboundTransformer() throws Exception {
        this.client.dispatch("vm://in3", (Object)"Test Message", null);
        this.latch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)this.serviceExceptionCounter.get());
        Assert.assertEquals((long)0L, (long)this.systemExceptionCounter.get());
        MuleMessage response = this.client.request("vm://out3", 500L);
        Assert.assertNull((Object)response);
    }

    @Test
    public void testOutboundResponseTransformer() throws Exception {
        this.client.dispatch("vm://in4", (Object)"Test Message", null);
        this.latch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)0L, (long)this.serviceExceptionCounter.get());
        Assert.assertEquals((long)0L, (long)this.systemExceptionCounter.get());
        MuleMessage response = this.client.request("vm://out4", 500L);
        Assert.assertNotNull((Object)response);
    }

    @Test
    public void testComponent() throws Exception {
        this.client.dispatch("vm://in5", (Object)"Test Message", null);
        this.latch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)this.serviceExceptionCounter.get());
        Assert.assertEquals((long)0L, (long)this.systemExceptionCounter.get());
    }

    @Test
    public void testInboundRouter() throws Exception {
        this.client.dispatch("vm://in6", (Object)"Test Message", null);
        this.latch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)this.serviceExceptionCounter.get());
        Assert.assertEquals((long)0L, (long)this.systemExceptionCounter.get());
    }

    @Test
    public void testOutboundRouter() throws Exception {
        this.client.dispatch("vm://in7", (Object)"Test Message", null);
        this.latch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)this.serviceExceptionCounter.get());
        Assert.assertEquals((long)0L, (long)this.systemExceptionCounter.get());
        MuleMessage response = this.client.request("vm://out7", 500L);
        Assert.assertNull((Object)response);
    }
}

