/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import java.util.concurrent.atomic.AtomicInteger;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.exception.SystemExceptionHandler;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.testmodels.mule.TestExceptionStrategy;
import org.mule.util.concurrent.Latch;

public abstract class AbstractExceptionStrategyTestCase
extends FunctionalTestCase {
    public static final int LATCH_AWAIT_TIMEOUT = 3000;
    protected final AtomicInteger systemExceptionCounter = new AtomicInteger();
    protected final AtomicInteger serviceExceptionCounter = new AtomicInteger();
    protected Latch latch;
    protected LocalMuleClient client;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        if (this.client == null) {
            this.client = muleContext.getClient();
        }
        this.latch = new Latch();
        this.systemExceptionCounter.set(0);
        this.serviceExceptionCounter.set(0);
        TestExceptionStrategy systemExceptionListener = new TestExceptionStrategy();
        systemExceptionListener.setExceptionCallback(new TestExceptionStrategy.ExceptionCallback(){

            public void onException(Throwable t) {
                AbstractExceptionStrategyTestCase.this.systemExceptionCounter.incrementAndGet();
                AbstractExceptionStrategyTestCase.this.latch.countDown();
            }
        });
        muleContext.setExceptionListener((SystemExceptionHandler)systemExceptionListener);
        TestExceptionStrategy serviceExceptionListener = (TestExceptionStrategy)muleContext.getRegistry().lookupModel("TestModel").getExceptionListener();
        serviceExceptionListener.setExceptionCallback(new TestExceptionStrategy.ExceptionCallback(){

            public void onException(Throwable t) {
                AbstractExceptionStrategyTestCase.this.serviceExceptionCounter.incrementAndGet();
                AbstractExceptionStrategyTestCase.this.latch.countDown();
            }
        });
    }

    protected void doTearDown() throws Exception {
        super.doTearDown();
        this.latch = null;
    }
}

