/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.enricher;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.processor.MessageProcessor;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class EnricherSessionPropertiesTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    protected String getConfigFile() {
        return "org/mule/test/integration/enricher/enricher-session-properties.xml";
    }

    @Test
    public void testCallingFlowUsingFlowRefInsideEnricher() throws Exception {
        System.setProperty("mule.enricher.propagateSession", "true");
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://in", (Object)"some message", null, 3000L);
        Assert.assertThat((Object)response, (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)Is.is((Object)"some message"));
        Assert.assertThat((Object)response.getExceptionPayload(), (Matcher)IsNull.nullValue());
    }

    public static class Spy
    implements MessageProcessor {
        public MuleEvent process(MuleEvent event) throws MuleException {
            Object enrichedContent = event.getMessage().getInvocationProperty("enrichedContent");
            Assert.assertThat((Object)((String)enrichedContent), (Matcher)Is.is((Object)"some message received by subflow"));
            Assert.assertThat((Object)event.getSession().getProperty("subFlowSessionProperty"), (Matcher)Is.is((Object)"someValue"));
            Assert.assertThat((Object)event.getMessage().getSessionProperty("subFlowSessionProperty"), (Matcher)Is.is((Object)"someValue"));
            Assert.assertThat((Object)event.getSession().getProperty("mainFlowSessionProperty"), (Matcher)Is.is((Object)"someValue"));
            return event;
        }
    }
}

