/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.endpoints;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;

public class EndpointMessageProcessorsTestCase
extends FunctionalTestCase {
    private static final int TIMEOUT = 5000;

    protected String getConfigFile() {
        return "org/mule/test/integration/endpoints/endpoint-message-processors.xml";
    }

    @Test
    public void testSynchronousOutbound() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://in1", (Object)"input", null);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)"input:A:B:service1:E:F:service2:G:H:C:D", (Object)response.getPayload());
    }

    @Test
    public void testAsynchronousOutbound() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://in2", (Object)"input", null);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)"input:A:B:service1:C:D", (Object)response.getPayload());
        response = client.request("vm://out2", 5000L);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)"input:A:B:service1:E:F", (Object)response.getPayload());
    }

    @Test
    public void testLegacyAttributes() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://in3", (Object)"input", null);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)"input:A:B:service1:E:F:service2:G:H:C:D", (Object)response.getPayload());
    }

    @Test
    public void testRouters() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://in4", (Object)"input1,input2,input3", null);
        MuleMessage response = client.request("vm://wiretap1", 5000L);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)"input1,input2,input3 (tapped)", (Object)response.getPayload());
        response = client.request("vm://wiretap2", 5000L);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)response.getPayloadAsString().startsWith("input"));
        Assert.assertTrue((boolean)response.getPayloadAsString().endsWith(":A:B:service1 (tapped)"));
        response = client.request("vm://wiretap2", 5000L);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)response.getPayloadAsString().startsWith("input"));
        Assert.assertTrue((boolean)response.getPayloadAsString().endsWith(":A:B:service1 (tapped)"));
        response = client.request("vm://wiretap2", 5000L);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)response.getPayloadAsString().startsWith("input"));
        Assert.assertTrue((boolean)response.getPayloadAsString().endsWith(":A:B:service1 (tapped)"));
        response = client.request("vm://wiretap2", 5000L);
        Assert.assertNull((Object)response);
        response = client.request("vm://out4", 5000L);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)response.getPayloadAsString().startsWith("input"));
        Assert.assertTrue((boolean)response.getPayloadAsString().endsWith(":A:B:service1:E:F"));
        response = client.request("vm://out4", 5000L);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)response.getPayloadAsString().startsWith("input"));
        Assert.assertTrue((boolean)response.getPayloadAsString().endsWith(":A:B:service1:E:F"));
        response = client.request("vm://out4", 5000L);
        Assert.assertNotNull((Object)response);
        Assert.assertTrue((boolean)response.getPayloadAsString().startsWith("input"));
        Assert.assertTrue((boolean)response.getPayloadAsString().endsWith(":A:B:service1:E:F"));
        response = client.request("vm://out4", 5000L);
        Assert.assertNull((Object)response);
    }
}

