/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.endpoints;

import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public abstract class AbstractEndpointEncodedUrlTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");

    protected String[] getConfigFiles() {
        return new String[]{"org/mule/test/integration/endpoints/secure-test-server-config.xml", this.getEncodedUrlConfigFile()};
    }

    protected abstract String getEncodedUrlConfigFile();

    @Test
    public void resolvesDynamicAddress() throws Exception {
        this.doEncodedUrlTest(this.getDynamicUrl());
    }

    @Test
    public void resolvesAssembledDynamicAddress() throws Exception {
        this.doEncodedUrlTest(this.getAssembledDynamicUrl());
    }

    @Test
    public void resolvesStaticAddress() throws Exception {
        this.doEncodedUrlTest(this.getStaticUrl());
    }

    @Test
    public void resolvesAssembledStaticAddress() throws Exception {
        this.doEncodedUrlTest(this.getAssembledStaticUrl());
    }

    protected void doEncodedUrlTest(String inputUrl) throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> messageProperties = new HashMap<String, String>();
        messageProperties.put("path", "test");
        MuleMessage response = client.send(inputUrl, (Object)"Test Message", messageProperties);
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)CoreMatchers.equalTo((Object)"Processed: bar"));
    }

    protected abstract String getDynamicUrl();

    protected abstract String getAssembledDynamicUrl();

    protected abstract String getStaticUrl();

    protected abstract String getAssembledStaticUrl();
}

