/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.domain.xa;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.rules.ExpectedException;
import org.mule.api.config.ConfigurationException;
import org.mule.config.ExceptionHelper;
import org.mule.tck.junit4.DomainFunctionalTestCase;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;

public class XaTransactionManagerTestCase
extends DomainFunctionalTestCase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    public static final String APPLICATION_NAME = "app";

    public void setUpMuleContexts() throws Exception {
        this.thrown.expect(ConfigurationException.class);
        this.thrown.expect(ThrowableMessageMatcher.hasMessage((Matcher)CoreMatchers.containsString((String)"No qualifying bean of type 'org.mule.api.transaction.TransactionManagerFactory' available: expected single matching bean but found 2:")));
        this.thrown.expect(ThrowableRootCauseMatcher.hasRootCause(IsInstanceOf.instanceOf(NoUniqueBeanDefinitionException.class)));
        super.setUpMuleContexts();
    }

    protected String getDomainConfig() {
        return "domain/xa/jboss-ts-config.xml";
    }

    public DomainFunctionalTestCase.ApplicationConfig[] getConfigResources() {
        return new DomainFunctionalTestCase.ApplicationConfig[]{new DomainFunctionalTestCase.ApplicationConfig((DomainFunctionalTestCase)this, APPLICATION_NAME, new String[]{"domain/xa/app-with-tx-manager-config.xml"})};
    }

    @Test
    public void validateOnlyOneTxManagerCanBeUsed() {
        this.getMuleContextForApp(APPLICATION_NAME).getTransactionManager();
    }

    public static class ThrowableRootCauseMatcher<T extends Throwable>
    extends TypeSafeMatcher<T> {
        private final Matcher<T> fMatcher;

        public ThrowableRootCauseMatcher(Matcher<T> matcher) {
            this.fMatcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendText("exception with root cause ");
            description.appendDescriptionOf(this.fMatcher);
        }

        protected boolean matchesSafely(T item) {
            return this.fMatcher.matches((Object)ExceptionHelper.getRootException(item));
        }

        protected void describeMismatchSafely(T item, Description description) {
            description.appendText("root cause ");
            this.fMatcher.describeMismatch((Object)ExceptionHelper.getRootException(item), description);
        }

        @Factory
        public static <T extends Throwable> Matcher<T> hasRootCause(Matcher<T> matcher) {
            return new ThrowableRootCauseMatcher<T>(matcher);
        }
    }
}

