/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.domain.registry;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.source.MessageSource;
import org.mule.construct.Flow;
import org.mule.endpoint.AbstractEndpoint;
import org.mule.tck.junit4.DomainFunctionalTestCase;

public class DomainEndpointCreationTestCase
extends DomainFunctionalTestCase {
    private static final String APP = "app";
    private static final String[] APPLICATION_RESOURCES = new String[]{"domain/app-jms-endpoints-config.xml"};

    protected String getDomainConfig() {
        return "domain/jms-shared-connector.xml";
    }

    public DomainFunctionalTestCase.ApplicationConfig[] getConfigResources() {
        return new DomainFunctionalTestCase.ApplicationConfig[]{new DomainFunctionalTestCase.ApplicationConfig((DomainFunctionalTestCase)this, APP, APPLICATION_RESOURCES)};
    }

    @Test
    public void registerTransformerOnce() throws Exception {
        MuleContext appContext = this.getMuleContextForApp(APP);
        Flow flow = (Flow)appContext.getRegistry().lookupObject("main");
        MessageSource messageSource = flow.getMessageSource();
        MatcherAssert.assertThat((Object)((AbstractEndpoint)messageSource).getMuleContext(), (Matcher)Matchers.equalTo((Object)appContext));
        MessageProcessor messageProcessor = (MessageProcessor)flow.getMessageProcessors().get(0);
        MatcherAssert.assertThat((Object)((AbstractEndpoint)messageProcessor).getMuleContext(), (Matcher)Matchers.equalTo((Object)appContext));
    }
}

