/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.domain.http;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.junit4.DomainFunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

@RunWith(value=Parameterized.class)
public class HttpSharePortTestCase
extends DomainFunctionalTestCase {
    public static final String HELLO_WORLD_SERVICE_APP = "helloWorldServiceApp";
    public static final String HELLO_MULE_SERVICE_APP = "helloMuleServiceApp";
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");
    @Rule
    public SystemProperty endpointScheme = this.getEndpointSchemeSystemProperty();
    private String hellowWordAppConfig;
    private String helloMuleAppConfig;
    private String domainConfig;

    public HttpSharePortTestCase(String domainConfig, String helloWorldAppConfig, String helloMuleAppConfig) {
        this.domainConfig = domainConfig;
        this.hellowWordAppConfig = helloWorldAppConfig;
        this.helloMuleAppConfig = helloMuleAppConfig;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"domain/http/transport/http-shared-connector.xml", "domain/http/transport/http-hello-world-app.xml", "domain/http/transport/http-hello-mule-app.xml"}, {"domain/http/http-shared-listener-config.xml", "domain/http/http-hello-world-app.xml", "domain/http/http-hello-mule-app.xml"});
    }

    protected String getDomainConfig() {
        return this.domainConfig;
    }

    public DomainFunctionalTestCase.ApplicationConfig[] getConfigResources() {
        return new DomainFunctionalTestCase.ApplicationConfig[]{new DomainFunctionalTestCase.ApplicationConfig((DomainFunctionalTestCase)this, HELLO_WORLD_SERVICE_APP, new String[]{this.hellowWordAppConfig}), new DomainFunctionalTestCase.ApplicationConfig((DomainFunctionalTestCase)this, HELLO_MULE_SERVICE_APP, new String[]{this.helloMuleAppConfig})};
    }

    @Test
    public void bothServicesBindCorrectly() throws Exception {
        MuleMessage helloWorldServiceResponse = this.getMuleContextForApp(HELLO_WORLD_SERVICE_APP).getClient().send(String.format("%s://localhost:%d/service/helloWorld", this.endpointScheme.getValue(), this.dynamicPort.getNumber()), (MuleMessage)new DefaultMuleMessage((Object)"test-data", this.getMuleContextForApp(HELLO_WORLD_SERVICE_APP)), (OperationOptions)this.getOptionsBuilder().build());
        Assert.assertThat((Object)helloWorldServiceResponse.getPayloadAsString(), (Matcher)Is.is((Object)"hello world"));
        MuleMessage helloMuleServiceResponse = this.getMuleContextForApp(HELLO_MULE_SERVICE_APP).getClient().send(String.format("%s://localhost:%d/service/helloMule", this.endpointScheme.getValue(), this.dynamicPort.getNumber()), (MuleMessage)new DefaultMuleMessage((Object)"test-data", this.getMuleContextForApp(HELLO_MULE_SERVICE_APP)), (OperationOptions)this.getOptionsBuilder().build());
        Assert.assertThat((Object)helloMuleServiceResponse.getPayloadAsString(), (Matcher)Is.is((Object)"hello mule"));
    }

    protected SystemProperty getEndpointSchemeSystemProperty() {
        return new SystemProperty("scheme", "http");
    }

    protected HttpRequestOptionsBuilder getOptionsBuilder() {
        return HttpRequestOptionsBuilder.newOptions();
    }
}

