/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.domain.http;

import org.hamcrest.core.IsInstanceOf;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mule.api.MuleContext;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.ApplicationContextBuilder;
import org.mule.tck.junit4.DomainContextBuilder;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

public class HttpSharePortSamePathTestCase
extends AbstractMuleTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");
    @Rule
    public SystemProperty endpointScheme = this.getEndpointSchemeSystemProperty();
    @Rule
    public ExpectedException expected = ExpectedException.none();
    private MuleContext domainContext;
    private MuleContext firstAppContext;

    @After
    public void after() {
        if (this.firstAppContext != null) {
            this.firstAppContext.dispose();
        }
        if (this.domainContext != null) {
            this.domainContext.dispose();
        }
    }

    @Test
    public void samePathDefinedInTwoAppsWithinSameDomain() throws Exception {
        this.domainContext = new DomainContextBuilder().setDomainConfig("domain/http/http-shared-listener-config.xml").build();
        this.firstAppContext = new ApplicationContextBuilder().setApplicationResources(new String[]{"domain/http/http-hello-mule-app.xml"}).setDomainContext(this.domainContext).build();
        ApplicationContextBuilder secondApp = new ApplicationContextBuilder();
        this.expected.expectCause(IsInstanceOf.instanceOf(InitialisationException.class));
        secondApp.setApplicationResources(new String[]{"domain/http/http-hello-mule-app.xml"}).setDomainContext(this.domainContext).build();
    }

    public SystemProperty getEndpointSchemeSystemProperty() {
        return new SystemProperty("scheme", "http");
    }
}

