/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.construct;

import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.math.RandomUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.MuleClient;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.concurrent.Latch;

public class ValidatorTestCase
extends FunctionalTestCase {
    private MuleClient muleClient;

    public ValidatorTestCase() {
        this.setDisposeContextPerClass(true);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.muleClient = muleContext.getClient();
    }

    protected String getConfigFile() {
        return "org/mule/test/integration/construct/validator-config.xml";
    }

    @Test
    public void testChildFilter() throws Exception {
        this.doTestValidator("validator");
    }

    @Test
    public void testFilterAndEndpointReferences() throws Exception {
        this.doTestValidator("validator-with-refs");
    }

    @Test
    public void testChildEndpoints() throws Exception {
        this.doTestValidator("validator-with-child-endpoints");
    }

    @Test
    public void testExceptionStrategy() throws Exception {
        this.doTestValidMessage("validator-with-exception-strategy");
        MuleMessage message = this.muleClient.send("vm://validator-with-exception-strategy.in", (Object)"abc", null);
        Assert.assertNotNull((Object)message);
        Assert.assertNotNull((Object)message.getExceptionPayload());
        Assert.assertEquals(IllegalArgumentException.class, message.getExceptionPayload().getRootException().getClass());
    }

    @Test
    public void testInheritance() throws Exception {
        this.doTestValidator("concrete-validator");
    }

    @Test
    public void testDispatchError() throws Exception {
        this.doTestValidMessageError("dispatch-error");
    }

    private void doTestValidator(String serviceName) throws Exception {
        this.doTestValidMessage(serviceName);
        this.doTestInvalidMessageNack(serviceName);
    }

    private void doTestValidMessage(String serviceName) throws MuleException, Exception, InterruptedException {
        FunctionalTestComponent ftc = this.getFunctionalTestComponent("test-service");
        final Latch latch = new Latch();
        ftc.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                latch.countDown();
            }
        });
        Object validPayload = this.doTestValidMessageAck(serviceName);
        latch.await((long)this.getTestTimeoutSecs(), TimeUnit.SECONDS);
        Assert.assertEquals((long)1L, (long)ftc.getReceivedMessagesCount());
        Assert.assertEquals((Object)validPayload, (Object)ftc.getLastReceivedMessage());
        ftc.initialise();
    }

    private Object doTestValidMessageAck(String serviceName) throws MuleException {
        Integer payload = RandomUtils.nextInt();
        Assert.assertEquals((Object)("GOOD:" + payload + "@" + serviceName), (Object)this.muleClient.send("vm://" + serviceName + ".in", (Object)payload, null).getPayload());
        return payload;
    }

    private Object doTestValidMessageError(String serviceName) throws MuleException {
        Integer payload = 777;
        Assert.assertEquals((Object)("ERROR:" + payload + "@" + serviceName), (Object)this.muleClient.send("vm://" + serviceName + ".in", (Object)payload, null).getPayload());
        return payload;
    }

    private void doTestInvalidMessageNack(String serviceName) throws MuleException {
        Assert.assertEquals((Object)("BAD:abc@" + serviceName), (Object)this.muleClient.send("vm://" + serviceName + ".in", (Object)"abc", null).getPayload());
    }
}

