/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.construct;

import java.io.InputStream;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.construct.SimpleService;
import org.mule.tck.exceptions.FunctionalTestException;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.integration.tck.WeatherForecaster;
import org.mule.util.StringUtils;
import org.springframework.util.FileCopyUtils;

public class SimpleServiceTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");
    @Rule
    public DynamicPort port2 = new DynamicPort("port2");
    private LocalMuleClient muleClient;

    protected String getConfigFile() {
        return "org/mule/test/integration/construct/simple-service-config.xml";
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.muleClient = muleContext.getClient();
    }

    @Test
    public void testPureAttributes() throws Exception {
        this.doTestMathsService("vm://maths1.in");
    }

    @Test
    public void testAbstractInheritence() throws Exception {
        this.doTestMathsService("vm://maths2.in");
    }

    @Test
    public void testEndpointReference() throws Exception {
        this.doTestMathsService("vm://maths3.in");
    }

    @Test
    public void testComponentReference() throws Exception {
        this.doTestMathsService("vm://maths4.in");
    }

    @Test
    public void testChildComponent() throws Exception {
        this.doTestMathsService("vm://maths5.in");
    }

    @Test
    public void testTransformerReferences() throws Exception {
        this.doTestStringMassager("vm://bam1.in");
    }

    @Test
    public void testConcreteInheritence() throws Exception {
        this.doTestStringMassager("vm://bam2.in");
    }

    @Test
    public void testComponentWithEntryPointResolver() throws Exception {
        this.doTestMathsService("vm://maths6.in");
    }

    @Test
    public void testChildEndpoint() throws Exception {
        this.doTestMathsService("vm://maths7.in");
    }

    @Test
    public void testInheritedExceptionStrategy() throws Exception {
        MuleMessage message = this.muleClient.send("vm://iexst.in", (Object)"ignored", null);
        Assert.assertNotNull((Object)message);
        Assert.assertNotNull((Object)message.getExceptionPayload());
        Assert.assertEquals(FunctionalTestException.class, message.getExceptionPayload().getRootException().getClass());
    }

    @Test
    public void testJaxWsService() throws Exception {
        this.doTestJaxWsService(this.port1);
    }

    @Test
    public void testJaxbConsumer() throws Exception {
        String result = this.muleClient.send("vm://weather-consumer.in", (Object)Thread.currentThread().getContextClassLoader().getResourceAsStream("org/mule/test/integration/construct/weather-report.xml"), null).getPayload().toString();
        Assert.assertTrue((boolean)StringUtils.isNotBlank((String)result));
    }

    @Test
    public void testXpathConsumer() throws Exception {
        String result = this.muleClient.send("vm://weather-xpath-consumer.in", (Object)Thread.currentThread().getContextClassLoader().getResourceAsStream("org/mule/test/integration/construct/weather-report.xml"), null).getPayload().toString();
        Assert.assertTrue((boolean)StringUtils.isNotBlank((String)result));
    }

    @Test
    public void testFunctionalTestComponent() throws Exception {
        this.doTestFunctionalTestComponent("vm://ftc1.in", "functional-test-component-1");
    }

    @Test
    public void testInheritedType() throws Exception {
        this.doTestJaxWsService(this.port2);
    }

    @Test
    public void testInheritedElementsUnique() throws Exception {
        SimpleService child1 = (SimpleService)this.getFlowConstruct("child-service-1");
        SimpleService child2 = (SimpleService)this.getFlowConstruct("child-service-2");
        Assert.assertNotSame((Object)child1.getMessageSource(), (Object)child2.getMessageSource());
        Assert.assertNotSame((Object)child1.getComponent(), (Object)child2.getComponent());
        Assert.assertNotSame((Object)child1.getExceptionListener(), (Object)child2.getExceptionListener());
    }

    private void doTestFunctionalTestComponent(String ftcUri, String ftcName) throws MuleException, Exception {
        String s = RandomStringUtils.randomAlphabetic((int)10);
        this.muleClient.send(ftcUri, (Object)s, null);
        Assert.assertEquals((Object)s, (Object)this.getFunctionalTestComponent(ftcName).getLastReceivedMessage());
    }

    private void doTestMathsService(String url) throws MuleException {
        int a = RandomUtils.nextInt((int)100);
        int b = RandomUtils.nextInt((int)100);
        int result = (Integer)this.muleClient.send(url, (Object)new int[]{a, b}, null).getPayload();
        Assert.assertEquals((long)(a + b), (long)result);
    }

    private void doTestStringMassager(String url) throws Exception, MuleException {
        String s = RandomStringUtils.randomAlphabetic((int)10);
        String result = new String((byte[])this.muleClient.send(url, (Object)s.getBytes(), null).getPayload());
        Assert.assertEquals((Object)(s + "barbaz"), (Object)result);
    }

    private void doTestJaxWsService(DynamicPort dynamicPort) throws Exception {
        int port = dynamicPort.getNumber();
        String url = String.format("http://localhost:%d/weather-forecast?wsdl", port);
        String wsdl = new String(FileCopyUtils.copyToByteArray((InputStream)((InputStream)this.muleClient.request(url, (long)this.getTestTimeoutSecs() * 1000L).getPayload())));
        Assert.assertTrue((boolean)wsdl.contains("GetWeatherByZipCode"));
        String weatherForecast = this.muleClient.send("wsdl-cxf:http://localhost:" + port + "/weather-forecast?wsdl&method=GetWeatherByZipCode", (Object)"95050", null, (long)(this.getTestTimeoutSecs() * 1000)).getPayloadAsString();
        Assert.assertEquals((Object)new WeatherForecaster().getByZipCode("95050"), (Object)weatherForecast);
    }
}

