/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.construct;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.MuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpProxyTestCase
extends AbstractServiceAndFlowTestCase {
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");
    @Rule
    public DynamicPort port2 = new DynamicPort("port2");
    private MuleClient muleClient;

    public HttpProxyTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList(new Object[][]{{AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/construct/http-proxy-config.xml"}});
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.muleClient = muleContext.getClient();
    }

    @Test
    public void testDirect() throws Exception {
        this.testDirectRequest(0);
    }

    @Test
    public void testEndpointChildren() throws Exception {
        this.testDirectRequest(1);
    }

    @Test
    public void testExceptionStrategy() throws Exception {
        this.testDirectRequest(2);
    }

    @Test
    public void testTransforming() throws Exception {
        this.testRequest(3, "fooinbarout");
    }

    @Test
    public void testInheritance() throws Exception {
        this.testRequest(4, "fooinbarout");
    }

    @Test
    public void testDynamicAddress() throws Exception {
        this.testExtraHeadersRequest(5, Collections.singletonMap("proxyTarget", "bar-appender"));
    }

    @Test
    public void testPathExtensions() throws Exception {
        this.testRequest(1, "/extension", "foobar", Collections.EMPTY_MAP);
        this.testRequest(1, "?name=value", "foobar", Collections.EMPTY_MAP);
        this.testRequest(1, "/other?name=value", "foobar", Collections.EMPTY_MAP);
    }

    private void testDirectRequest(int proxyId) throws Exception {
        this.testRequest(proxyId, "foobar");
    }

    private void testExtraHeadersRequest(int proxyId, Map<String, String> extraHeaders) throws Exception {
        this.testRequest(proxyId, "foobar", extraHeaders);
    }

    private void testRequest(int proxyId, String expectedResult) throws Exception {
        this.testRequest(proxyId, expectedResult, Collections.EMPTY_MAP);
    }

    private void testRequest(int proxyId, String expectedResult, Map<String, String> extraHeaders) throws Exception {
        this.testRequest(proxyId, "", expectedResult, extraHeaders);
    }

    private void testRequest(int proxyId, String pathExtension, String expectedResult, Map<String, String> extraHeaders) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>(Collections.singletonMap("X-Custom-Header", "w00t"));
        headers.putAll(extraHeaders);
        MuleMessage result = this.muleClient.send("http://localhost:" + this.port1.getNumber() + "/http-proxy/" + proxyId + pathExtension, (Object)"foo", headers, (long)(this.getTestTimeoutSecs() * 1000));
        Assert.assertEquals((Object)expectedResult, (Object)result.getPayloadAsString());
        int contentLength = this.getContentLength(result);
        Assert.assertEquals((long)expectedResult.length(), (long)contentLength);
        Assert.assertEquals((Object)"w00tbaz", (Object)result.getInboundProperty("X-Custom-Header-Response"));
        Assert.assertEquals((Object)("/bar-appender" + pathExtension), (Object)result.getInboundProperty("X-Actual-Request-Path"));
    }

    private int getContentLength(MuleMessage result) {
        Object messageProperty = result.getInboundProperty("Content-Length");
        return Integer.parseInt(messageProperty.toString());
    }
}

