/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.components;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class NoArgsCallComponentTestCase
extends AbstractServiceAndFlowTestCase {
    public static final String INPUT_DC_QUEUE_NAME = "vm://in";
    public static final String OUTPUT_DC_QUEUE_NAME = "vm://out";
    public static final String INPUT_DI_QUEUE_NAME = "vm://invokeWithInjected";
    public static final String OUTPUT_DI_QUEUE_NAME = "vm://outWithInjected";
    public static final String DEFAULT_INPUT_MESSAGE = "test";
    public static final String DEFUALT_OUTPUT_MESSAGE = "Just an apple.";
    public static final int TIMEOUT = 5000;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/components/no-args-call-component-functional-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/components/no-args-call-component-functional-test-flow.xml"});
    }

    public NoArgsCallComponentTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testDelegateClass() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch(INPUT_DC_QUEUE_NAME, (Object)DEFAULT_INPUT_MESSAGE, null);
        MuleMessage message = client.request(OUTPUT_DC_QUEUE_NAME, 5000L);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)message.getPayload(), (Object)DEFUALT_OUTPUT_MESSAGE);
    }

    @Test
    public void testWithInjectedDelegate() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch(INPUT_DI_QUEUE_NAME, (Object)DEFAULT_INPUT_MESSAGE, null);
        MuleMessage reply = client.request(OUTPUT_DI_QUEUE_NAME, 5000L);
        Assert.assertNotNull((Object)reply);
        Assert.assertNull((Object)reply.getExceptionPayload());
        Assert.assertEquals((Object)DEFAULT_INPUT_MESSAGE, (Object)reply.getPayload());
    }
}

