/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.wire.WireFormat;
import org.mule.module.client.remoting.notification.RemoteDispatcherNotification;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.transformer.wire.SerializationWireFormat;

public class RemoteDispatcherSerializationTestCase
extends AbstractMuleContextTestCase {
    protected RemoteDispatcherNotification getNotification() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("key1", "value1");
        Apple apple = new Apple();
        apple.wash();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)apple, props, muleContext);
        RemoteDispatcherNotification notification = new RemoteDispatcherNotification((MuleMessage)message, 603, "vm://foo");
        notification.setProperty((Object)"foo", (Object)"bar");
        return notification;
    }

    @Test
    public void testNotificationJavaSerialization() throws Exception {
        this.doTestNotificationSerialization((WireFormat)this.createObject(SerializationWireFormat.class));
    }

    public void doTestNotificationSerialization(WireFormat wf) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        wf.write((OutputStream)baos, (Object)this.getNotification(), "UTF-8");
        Object result = wf.read((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof RemoteDispatcherNotification));
        this.doTestNotification((RemoteDispatcherNotification)result);
    }

    protected void doTestNotification(RemoteDispatcherNotification n) throws Exception {
        Assert.assertEquals((Object)"bar", (Object)n.getProperty((Object)"foo"));
        MuleMessage m = n.getMessage();
        Assert.assertTrue((boolean)(m.getPayload() instanceof Apple));
        Assert.assertTrue((boolean)((Apple)m.getPayload()).isWashed());
        Assert.assertEquals((Object)"value1", (Object)m.getOutboundProperty("key1"));
    }
}

