/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.client;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleClientTestCase
extends FunctionalTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(MuleClientTestCase.class);

    protected String getConfigFile() {
        return "org/mule/test/integration/client/test-client-mule-config.xml";
    }

    @Test
    public void testClientSendDirect() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage message = client.sendDirect("TestReceiverUMO", null, (Object)"Test Client Send message", null);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"Test Client Send message Received", (Object)message.getPayload());
    }

    @Test
    public void testClientDispatchDirect() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        client.dispatchDirect("TestReceiverUMO", (Object)"Test Client dispatch message", null);
    }

    @Test
    public void testClientSendGlobalEndpoint() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage message = client.send("vmEndpoint", (Object)"Test Client Send message", null);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"Test Client Send message Received", (Object)message.getPayload());
    }

    @Test
    public void testClientSend() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage message = client.send(this.getDispatchUrl(), (Object)"Test Client Send message", null);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"Test Client Send message Received", (Object)message.getPayload());
    }

    @Test
    public void testClientMultiSend() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        for (int i = 0; i < 100; ++i) {
            MuleMessage message = client.send(this.getDispatchUrl(), (Object)("Test Client Send message " + i), null);
            Assert.assertNotNull((Object)message);
            Assert.assertEquals((Object)("Test Client Send message " + i + " Received"), (Object)message.getPayload());
        }
    }

    @Test
    public void testClientMultidispatch() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        int i = 0;
        client.dispatch(this.getDispatchUrl(), (Object)("Test Client Send message " + i), null);
        long start = System.currentTimeMillis();
        for (i = 0; i < 100; ++i) {
            client.dispatch(this.getDispatchUrl(), (Object)("Test Client Send message " + i), null);
        }
        long time = System.currentTimeMillis() - start;
        LOGGER.debug(i + " took " + time + "ms to process");
        Thread.sleep(1000L);
    }

    public String getDispatchUrl() {
        return "vm://test.queue";
    }
}

