/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.client;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.module.client.RemoteDispatcher;
import org.mule.tck.junit4.FunctionalTestCase;

public abstract class AbstractClientRemotingTestCase
extends FunctionalTestCase {
    public abstract String getRemoteEndpointUri();

    @Test
    public void testClientSendToRemoteComponent() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        RemoteDispatcher dispatcher = client.getRemoteDispatcher(this.getRemoteEndpointUri());
        MuleMessage message = dispatcher.sendToRemoteComponent("TestReceiverUMO", (Object)"Test Client Send message", null);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"Test Client Send message Received", (Object)message.getPayload());
    }

    @Test
    public void testClientRequestResponseOnEndpoint() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        RemoteDispatcher dispatcher = client.getRemoteDispatcher(this.getRemoteEndpointUri());
        MuleMessage message = dispatcher.sendRemote("vm://remote.endpoint?connector=vmRemoteConnector", (Object)"foo", null);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"received from remote component", (Object)message.getPayloadAsString());
    }

    @Test
    public void testClientSendAndReceiveRemote() throws Exception {
        String remoteEndpoint = "vm://remote.queue?connector=vmRemoteQueueConnector";
        MuleClient client = new MuleClient(muleContext);
        RemoteDispatcher dispatcher = client.getRemoteDispatcher(this.getRemoteEndpointUri());
        MuleMessage message = dispatcher.receiveRemote(remoteEndpoint, Integer.MIN_VALUE);
        Assert.assertNull((Object)message);
        dispatcher.sendRemote(remoteEndpoint, (Object)"Test Remote Message 2", null);
        message = dispatcher.receiveRemote(remoteEndpoint, 10000);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"Test Remote Message 2", (Object)message.getPayload());
    }
}

