/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.async;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.listener.FlowExecutionListener;
import org.mule.transport.NullPayload;

public class SedaStageWorkRejectionTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/integration/async/seda-stage-work-rejection-config-flow.xml";
    }

    @Test
    public void handleWorkRejectedWithExceptionStrategy() throws Exception {
        FlowExecutionListener flowExecutionListener = new FlowExecutionListener("limitedThreadsFlow", muleContext).setTimeoutInMillis(5000).setNumberOfExecutionsRequired(3);
        this.testThirdMessageSendToExceptionStrategy("vm://flow1.in", flowExecutionListener);
    }

    @Test
    public void handleQueueFullWithExceptionStrategy() throws Exception {
        FlowExecutionListener flowExecutionListener = new FlowExecutionListener("limitedQueueFlow", muleContext).setTimeoutInMillis(5000).setNumberOfExecutionsRequired(3);
        this.testThirdMessageSendToExceptionStrategy("vm://flow2.in", flowExecutionListener);
    }

    protected void testThirdMessageSendToExceptionStrategy(String inUrl, FlowExecutionListener flowExecutionListener) throws Exception {
        int i;
        LocalMuleClient client = muleContext.getClient();
        int nrMessages = 3;
        for (i = 0; i < nrMessages; ++i) {
            client.dispatch(inUrl, (Object)("Test Message" + i), null);
        }
        flowExecutionListener.waitUntilFlowIsComplete();
        for (i = 0; i < 2; ++i) {
            MuleMessage result = client.request("vm://out", 5000L);
            Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
            Assert.assertThat((Object)result.getExceptionPayload(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
            Assert.assertThat((Object)result.getPayload(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(NullPayload.class)));
            Assert.assertThat((Object)result.getPayloadAsString(), (Matcher)CoreMatchers.containsString((String)"Test Message"));
        }
        Assert.assertThat((Object)client.request("vm://out", 1000L), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MuleMessage result = client.request("vm://exception", 5000L);
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }
}

