/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.schedule.Schedulers;
import org.mule.tck.junit4.FunctionalTestCase;

public class PollingTestCase
extends FunctionalTestCase {
    private static List<String> foo;
    private static List<String> bar;
    private static List<MuleEvent> events;
    private static List<String> eventIds;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        foo = new ArrayList<String>();
        bar = new ArrayList<String>();
        events = new ArrayList<MuleEvent>();
        eventIds = new ArrayList<String>();
    }

    protected String getConfigFile() {
        return "org/mule/test/integration/polling-config.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPolling() throws Exception {
        Collection schedulers = muleContext.getRegistry().lookupScheduler(Schedulers.allPollSchedulers());
        Assert.assertEquals((long)4L, (long)schedulers.size());
        Thread.sleep(5000L);
        List<String> list = foo;
        synchronized (list) {
            Assert.assertTrue((foo.size() > 0 ? 1 : 0) != 0);
            for (String s : foo) {
                Assert.assertEquals((Object)s, (Object)"foo");
            }
        }
        list = bar;
        synchronized (list) {
            Assert.assertTrue((bar.size() > 0 ? 1 : 0) != 0);
            for (String s : bar) {
                Assert.assertEquals((Object)s, (Object)"bar");
            }
        }
        list = events;
        synchronized (list) {
            Assert.assertTrue((events.size() > 0 ? 1 : 0) != 0);
            Assert.assertEquals((long)events.size(), (long)eventIds.size());
            for (int i = 0; i < events.size(); ++i) {
                Assert.assertNotNull((Object)events.get(i));
                Assert.assertEquals((Object)events.get(i).getId(), (Object)eventIds.get(i));
            }
        }
    }

    public static class EventWireTrap
    implements MessageProcessor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MuleEvent process(MuleEvent event) throws MuleException {
            List list = events;
            synchronized (list) {
                events.add(RequestContext.getEvent());
                eventIds.add(event.getId());
            }
            return event;
        }
    }

    public static class BarComponent {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean process(String s) {
            List list = bar;
            synchronized (list) {
                if (bar.size() < 10) {
                    bar.add(s);
                    return true;
                }
            }
            return false;
        }
    }

    public static class FooComponent {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean process(String s) {
            List list = foo;
            synchronized (list) {
                if (foo.size() < 10) {
                    foo.add(s);
                    return true;
                }
            }
            return false;
        }
    }
}

