/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.routing.OutboundRouter;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.service.Service;
import org.mule.construct.Flow;
import org.mule.endpoint.DefaultInboundEndpoint;
import org.mule.module.xml.transformer.ObjectToXml;
import org.mule.service.ServiceCompositeMessageSource;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.MuleTestUtils;

public class MuleEndpointConfigurationTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/test-endpoints-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/test-endpoints-config-flow.xml"});
    }

    public MuleEndpointConfigurationTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testComponent3RouterEndpoints() throws Exception {
        Object serviceFlow = muleContext.getRegistry().lookupObject("TestComponent3");
        if (serviceFlow instanceof Service) {
            Assert.assertNotNull((Object)serviceFlow);
            OutboundRouterCollection outboundRouter = (OutboundRouterCollection)((Service)serviceFlow).getOutboundMessageProcessor();
            Assert.assertNotNull((Object)outboundRouter);
            Assert.assertEquals((long)2L, (long)outboundRouter.getRoutes().size());
            OutboundRouter router1 = (OutboundRouter)outboundRouter.getRoutes().get(0);
            Assert.assertEquals((long)1L, (long)router1.getRoutes().size());
            ImmutableEndpoint endpoint = (ImmutableEndpoint)router1.getRoutes().get(0);
            Assert.assertEquals((Object)"tcp", (Object)endpoint.getConnector().getProtocol().toLowerCase());
            Assert.assertEquals((Object)"tcp://localhost:60201", (Object)endpoint.getEndpointURI().getAddress());
            Assert.assertTrue((boolean)(endpoint instanceof OutboundEndpoint));
            OutboundRouter router2 = (OutboundRouter)outboundRouter.getRoutes().get(1);
            Assert.assertEquals((long)2L, (long)router2.getRoutes().size());
            endpoint = (ImmutableEndpoint)router2.getRoutes().get(0);
            Assert.assertEquals((Object)"udp", (Object)endpoint.getConnector().getProtocol().toLowerCase());
            Assert.assertEquals((Object)"udp://localhost:56731", (Object)endpoint.getEndpointURI().getAddress());
            Assert.assertTrue((boolean)(endpoint instanceof OutboundEndpoint));
            endpoint = (ImmutableEndpoint)router2.getRoutes().get(1);
            Assert.assertEquals((Object)"test", (Object)endpoint.getConnector().getProtocol().toLowerCase());
            Assert.assertEquals((Object)"test.queue2", (Object)endpoint.getEndpointURI().getAddress());
            Assert.assertTrue((boolean)(endpoint instanceof OutboundEndpoint));
        } else if (serviceFlow instanceof Flow) {
            Assert.assertNotNull((Object)serviceFlow);
            List messageProcessors = ((Flow)serviceFlow).getMessageProcessors();
            Assert.assertNotNull((Object)messageProcessors);
            Assert.assertEquals((long)2L, (long)messageProcessors.size());
            OutboundRouter allRouter = (OutboundRouter)messageProcessors.get(1);
            Assert.assertEquals((long)3L, (long)allRouter.getRoutes().size());
            ImmutableEndpoint endpoint = (ImmutableEndpoint)allRouter.getRoutes().get(0);
            Assert.assertEquals((Object)"tcp", (Object)endpoint.getConnector().getProtocol().toLowerCase());
            Assert.assertEquals((Object)"tcp://localhost:60201", (Object)endpoint.getEndpointURI().getAddress());
            Assert.assertTrue((boolean)(endpoint instanceof OutboundEndpoint));
            endpoint = (ImmutableEndpoint)allRouter.getRoutes().get(1);
            Assert.assertEquals((Object)"udp", (Object)endpoint.getConnector().getProtocol().toLowerCase());
            Assert.assertEquals((Object)"udp://localhost:56731", (Object)endpoint.getEndpointURI().getAddress());
            Assert.assertTrue((boolean)(endpoint instanceof OutboundEndpoint));
            endpoint = (ImmutableEndpoint)allRouter.getRoutes().get(2);
            Assert.assertEquals((Object)"test", (Object)endpoint.getConnector().getProtocol().toLowerCase());
            Assert.assertEquals((Object)"test.queue2", (Object)endpoint.getEndpointURI().getAddress());
            Assert.assertTrue((boolean)(endpoint instanceof OutboundEndpoint));
        } else {
            Assert.fail((String)"Unexpected Object");
        }
    }

    @Test
    public void testComponent4InboundEndpoint() throws Exception {
        Object serviceFlow = muleContext.getRegistry().lookupObject("TestComponent4");
        if (serviceFlow instanceof Service) {
            Assert.assertNotNull((Object)serviceFlow);
            Assert.assertNotNull((Object)((ServiceCompositeMessageSource)((Service)serviceFlow).getMessageSource()).getEndpoints());
            Assert.assertEquals((long)1L, (long)((ServiceCompositeMessageSource)((Service)serviceFlow).getMessageSource()).getEndpoints().size());
            ImmutableEndpoint endpoint = (ImmutableEndpoint)((ServiceCompositeMessageSource)((Service)serviceFlow).getMessageSource()).getEndpoints().get(0);
            Assert.assertNotNull((Object)endpoint);
            Assert.assertEquals((Object)"vm", (Object)endpoint.getConnector().getProtocol().toLowerCase());
            Assert.assertEquals((Object)"queue4", (Object)endpoint.getEndpointURI().getAddress());
            Assert.assertFalse((boolean)endpoint.getTransformers().isEmpty());
            Assert.assertTrue((boolean)(endpoint.getTransformers().get(0) instanceof ObjectToXml));
            Assert.assertTrue((boolean)(endpoint instanceof InboundEndpoint));
        } else if (serviceFlow instanceof Flow) {
            Assert.assertNotNull((Object)serviceFlow);
            Assert.assertNotNull((Object)((Flow)serviceFlow).getMessageSource());
            Assert.assertEquals((long)1L, (long)((DefaultInboundEndpoint)((Flow)serviceFlow).getMessageSource()).getMessageProcessors().size());
            DefaultInboundEndpoint endpoint = (DefaultInboundEndpoint)((Flow)serviceFlow).getMessageSource();
            Assert.assertNotNull((Object)endpoint);
            Assert.assertEquals((Object)"vm", (Object)endpoint.getConnector().getProtocol().toLowerCase());
            Assert.assertEquals((Object)"queue4", (Object)endpoint.getEndpointURI().getAddress());
            Assert.assertFalse((boolean)endpoint.getTransformers().isEmpty());
            Assert.assertTrue((boolean)(endpoint.getTransformers().get(0) instanceof ObjectToXml));
            Assert.assertTrue((boolean)(endpoint instanceof InboundEndpoint));
        } else {
            Assert.fail((String)"Unexpected Object");
        }
    }

    @Test
    public void testComponent4OutboundEndpoint() throws Exception {
        Object serviceFlow = muleContext.getRegistry().lookupObject("TestComponent4");
        if (serviceFlow instanceof Service) {
            Assert.assertNotNull((Object)serviceFlow);
            OutboundRouterCollection outboundRouter = (OutboundRouterCollection)((Service)serviceFlow).getOutboundMessageProcessor();
            Assert.assertNotNull((Object)outboundRouter);
            Assert.assertEquals((long)1L, (long)outboundRouter.getRoutes().size());
            OutboundRouter router = (OutboundRouter)outboundRouter.getRoutes().get(0);
            Assert.assertEquals((long)1L, (long)router.getRoutes().size());
            ImmutableEndpoint endpoint = (ImmutableEndpoint)router.getRoutes().get(0);
            Assert.assertEquals((Object)"udp", (Object)endpoint.getConnector().getProtocol().toLowerCase());
            Assert.assertEquals((Object)"udp://localhost:56731", (Object)endpoint.getEndpointURI().getAddress());
            Assert.assertTrue((boolean)(endpoint instanceof OutboundEndpoint));
        } else if (serviceFlow instanceof Flow) {
            Assert.assertNotNull((Object)serviceFlow);
            List messageProcessors = ((Flow)serviceFlow).getMessageProcessors();
            Assert.assertNotNull((Object)messageProcessors);
            ImmutableEndpoint endpoint = (ImmutableEndpoint)messageProcessors.get(1);
            Assert.assertEquals((Object)"udp", (Object)endpoint.getConnector().getProtocol().toLowerCase());
            Assert.assertEquals((Object)"udp://localhost:56731", (Object)endpoint.getEndpointURI().getAddress());
            Assert.assertTrue((boolean)(endpoint instanceof OutboundEndpoint));
        } else {
            Assert.fail((String)"Unexpected Object");
        }
    }

    @Test
    public void testComponent5RouterEndpoints() throws Exception {
        Object serviceFlow = muleContext.getRegistry().lookupObject("TestComponent5");
        if (serviceFlow instanceof Service) {
            Assert.assertNotNull((Object)serviceFlow);
            OutboundRouterCollection outboundRouter = (OutboundRouterCollection)((Service)serviceFlow).getOutboundMessageProcessor();
            Assert.assertNotNull((Object)outboundRouter);
            Assert.assertEquals((long)1L, (long)outboundRouter.getRoutes().size());
            OutboundRouter router = (OutboundRouter)outboundRouter.getRoutes().get(0);
            Assert.assertEquals((long)1L, (long)router.getRoutes().size());
            ImmutableEndpoint endpoint = (ImmutableEndpoint)router.getRoutes().get(0);
            Assert.assertEquals((Object)"tcp", (Object)endpoint.getConnector().getProtocol().toLowerCase());
            Assert.assertEquals((Object)"tcp://localhost:45431", (Object)endpoint.getEndpointURI().getAddress());
            Assert.assertTrue((boolean)(endpoint instanceof OutboundEndpoint));
        } else if (serviceFlow instanceof Flow) {
            Assert.assertNotNull((Object)serviceFlow);
            List messageProcessors = ((Flow)serviceFlow).getMessageProcessors();
            Assert.assertNotNull((Object)messageProcessors);
            ImmutableEndpoint endpoint = (ImmutableEndpoint)messageProcessors.get(1);
            Assert.assertEquals((Object)"tcp", (Object)endpoint.getConnector().getProtocol().toLowerCase());
            Assert.assertEquals((Object)"tcp://localhost:45431", (Object)endpoint.getEndpointURI().getAddress());
            Assert.assertTrue((boolean)(endpoint instanceof OutboundEndpoint));
        } else {
            Assert.fail((String)"Unexpected Object");
        }
    }

    @Test
    public void testEndpointFromURI() throws Exception {
        InboundEndpoint ep = muleContext.getEndpointFactory().getInboundEndpoint("test://hello?exchangePattern=request-response&responseTimeout=2002&connector=testConnector1");
        Assert.assertEquals((Object)MessageExchangePattern.REQUEST_RESPONSE, (Object)ep.getExchangePattern());
        Assert.assertEquals((long)2002L, (long)ep.getResponseTimeout());
        Assert.assertTrue((boolean)(ep instanceof InboundEndpoint));
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"hello", muleContext), ep, (FlowConstruct)MuleEndpointConfigurationTestCase.getTestService(), MuleTestUtils.getTestSession((MuleContext)muleContext));
        Assert.assertEquals((long)2002L, (long)event.getTimeout());
        InboundEndpoint ep2 = muleContext.getEndpointFactory().getInboundEndpoint("test://hello?connector=testConnector1");
        event = new DefaultMuleEvent((MuleMessage)new DefaultMuleMessage((Object)"hello", muleContext), ep2, (FlowConstruct)MuleEndpointConfigurationTestCase.getTestService(), MuleTestUtils.getTestSession((MuleContext)muleContext));
        Assert.assertEquals((long)1001L, (long)event.getTimeout());
    }
}

