/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.el;

import java.text.DateFormat;
import java.util.Locale;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.el.ExpressionLanguage;
import org.mule.api.expression.ExpressionManager;
import org.mule.tck.junit4.FunctionalTestCase;

public class ExpressionLanguageConfigTestCase
extends FunctionalTestCase {
    ExpressionLanguage el;
    ExpressionManager em;

    protected String getConfigFile() {
        return "org/mule/test/el/expression-language-config.xml";
    }

    @Before
    public void setup() {
        this.el = muleContext.getExpressionLanguage();
        this.em = muleContext.getExpressionManager();
    }

    @Test
    public void testExpressionLanguageImport() {
        Assert.assertEquals(Locale.class, (Object)this.el.evaluate("loc"));
        Assert.assertEquals(Locale.class, (Object)this.em.evaluate("loc", (MuleMessage)null));
    }

    @Test
    public void testExpressionLanguageImportNoName() {
        Assert.assertEquals(DateFormat.class, (Object)this.el.evaluate("DateFormat"));
        Assert.assertEquals(DateFormat.class, (Object)this.em.evaluate("DateFormat", (MuleMessage)null));
    }

    @Test
    public void testExpressionLanguageAlias() {
        Assert.assertEquals((Object)muleContext.getConfiguration().getId(), (Object)this.el.evaluate("appName"));
        Assert.assertEquals((Object)muleContext.getConfiguration().getId(), (Object)this.em.evaluate("appName", (MuleMessage)null));
    }

    @Test
    public void testExpressionLanguageGlobalFunction() {
        Assert.assertEquals((Object)"hi", (Object)this.el.evaluate("echo('hi')"));
        Assert.assertEquals((Object)"hi", (Object)this.em.evaluate("echo('hi')", (MuleMessage)null));
    }

    @Test
    public void testExpressionLanguageGlobalFunctionFromFile() {
        Assert.assertEquals((Object)"hi", (Object)this.el.evaluate("echo2('hi')"));
        Assert.assertEquals((Object)"hi", (Object)this.em.evaluate("echo2('hi')", (MuleMessage)null));
    }

    @Test
    public void testExpressionLanguageGlobalFunctionNotOverriden() {
        MatcherAssert.assertThat((Object)((String)this.el.evaluate("helloNotOverriden()")), (Matcher)CoreMatchers.equalTo((Object)("Hello " + muleContext.getConfiguration().getId() + "!")));
        MatcherAssert.assertThat((Object)((String)this.em.evaluate("helloNotOverriden()", (MuleMessage)null)), (Matcher)CoreMatchers.equalTo((Object)("Hello " + muleContext.getConfiguration().getId() + "!")));
    }

    @Test
    public void testExpressionLanguageGlobalFunctionUsingStaticContext() {
        Assert.assertEquals((Object)("Hello " + muleContext.getConfiguration().getId() + "!"), (Object)this.el.evaluate("hello()"));
        Assert.assertEquals((Object)("Hello " + muleContext.getConfiguration().getId() + "!"), (Object)this.em.evaluate("hello()", (MuleMessage)null));
    }

    @Test
    public void testExpressionLanguageGlobalFunctionUsingMessageContext() {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"123", muleContext);
        Assert.assertEquals((Object)"123appended", (Object)this.el.evaluate("appendPayload()", (MuleMessage)message));
        Assert.assertEquals((Object)"123appended", (Object)this.em.evaluate("appendPayload()", (MuleMessage)message));
    }

    @Test
    public void testExpressionLanguageGlobalFunctionUsingMessageContextAndImport() {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"123", muleContext);
        Assert.assertEquals((Object)"321", (Object)this.el.evaluate("reversePayload()", (MuleMessage)message));
        Assert.assertEquals((Object)"321", (Object)this.em.evaluate("reversePayload()", (MuleMessage)message));
    }

    @Test
    public void testExpressionLanguageExecuteElement() throws Exception {
        this.testFlow("flow", ExpressionLanguageConfigTestCase.getTestEvent((Object)"foo"));
    }
}

