/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.construct;

import java.io.File;
import java.io.IOException;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Test;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.listener.FlowExecutionListener;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowSyncAsyncProcessingStrategyTestCase
extends FunctionalTestCase {
    public static final String SLEEP_TIME = "sleepTime";
    private static final String FILE_PATH = "./test/testfile.txt";
    private File file;
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowSyncAsyncProcessingStrategyTestCase.class);

    protected String getConfigFile() {
        return "org/mule/test/construct/flow-sync-async-processing-strategy-config.xml";
    }

    @After
    public void cleanUp() {
        FileUtils.deleteQuietly((File)this.file);
    }

    @Test
    public void testSynchProcessingStrategy() throws Exception {
        this.sendMessage("vm://testSynch");
        new FlowExecutionListener("synchFlow", muleContext).waitUntilFlowIsComplete();
        this.file = new File(FILE_PATH);
        String str = FileUtils.readFileToString((File)this.file);
        Assert.assertEquals((String)"Part 1Part 2", (String)str);
    }

    @Test
    public void testAsynch() throws Exception {
        this.sendMessage("vm://testAsynch");
        this.file = new File(FILE_PATH);
        PollingProber prober = new PollingProber(10000L, 2000L);
        prober.check((Probe)new FileCompleteProbe());
    }

    private void sendMessage(String endpoint) throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch(endpoint, (Object)"Part 1;Part 2", null);
    }

    private class FileCompleteProbe
    implements Probe {
        private String output;

        private FileCompleteProbe() {
        }

        public boolean isSatisfied() {
            if (FlowSyncAsyncProcessingStrategyTestCase.this.file.exists()) {
                try {
                    this.output = FileUtils.readFileToString((File)FlowSyncAsyncProcessingStrategyTestCase.this.file);
                }
                catch (IOException e) {
                    LOGGER.debug("Could not read from file.");
                }
                return "Part 2Part 1".equals(this.output);
            }
            return false;
        }

        public String describeFailure() {
            return "Expected output was 'Part2Part 1' but actual one was: " + this.output;
        }
    }
}

