/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.construct;

import org.junit.Assert;
import org.junit.Ignore;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.test.construct.FlowDefaultProcessingStrategyTestCase;
import org.mule.transaction.TransactionCoordination;

@Ignore
public class FlowAynchronousProcessingStrategyTestCase
extends FlowDefaultProcessingStrategyTestCase {
    @Override
    protected String getConfigFile() {
        return "org/mule/test/construct/flow-asynchronous-processing-strategy-config.xml";
    }

    @Override
    public void testDispatchToOneWayInboundTxOnly() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://oneway-inboundtx-in", (Object)"a", null);
        MuleMessage result = client.request("vm://dead-letter-queue", 5000L);
        Assert.assertNotNull((Object)result);
    }

    @Override
    public void testDispatchToOneWayTx() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://onewaytx-in", (Object)"a", null);
        Assert.assertNull((Object)client.request("vm://onewaytx-out", 5000L));
    }

    @Override
    public void testSendToOneWayTx() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        try {
            client.send("vm://oneway-tx-in", (Object)"a", null);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            TransactionCoordination.getInstance().getTransaction().rollback();
        }
    }

    @Override
    public void testSendRequestResponseInbound() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        try {
            client.send("vm://requestresponse-in", (Object)"a", null);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void testDispatchToRequestResponseInboundOneWayOutbound() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://requestresponse-oneway-in", (Object)"a", null);
        Assert.assertNull((Object)client.request("vm://requestresponse-oneway-out", 5000L));
    }

    @Override
    public void testSendToRequestResponseInboundOneWayOutbound() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        try {
            client.send("vm://requestresponse-oneway-in", (Object)"a", null);
            Assert.fail((String)"Exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void assertAllProcessingInClientThread(MuleMessage result) {
        this.assertSync(result);
        Assert.assertEquals((Object)Thread.currentThread().getName(), (Object)result.getInboundProperty("receiver-thread"));
    }

    @Override
    protected void assertAllProcessingInRecieverThread(MuleMessage result) {
        this.assertSync(result);
        Assert.assertTrue((boolean)((String)result.getInboundProperty("receiver-thread")).startsWith("vm.receiver"));
    }

    @Override
    protected void assertSync(MuleMessage result) {
        Assert.assertNotNull((Object)result);
        String receiverThread = (String)result.getInboundProperty("receiver-thread");
        String flowThread = (String)result.getInboundProperty("processor-thread");
        String dispatcherThread = (String)result.getInboundProperty("dispatcher-thread");
        Assert.assertEquals((Object)receiverThread, (Object)flowThread);
        Assert.assertEquals((Object)flowThread, (Object)dispatcherThread);
    }

    @Override
    protected void assertAllProcessingAsync(MuleMessage result) {
        Assert.assertNotNull((Object)result);
        String receiverThread = (String)result.getInboundProperty("receiver-thread");
        String flowThread = (String)result.getInboundProperty("processor-thread");
        String dispatcherThread = (String)result.getInboundProperty("dispatcher-thread");
        Assert.assertTrue((boolean)receiverThread.startsWith("vm.receiver"));
        Assert.assertFalse((boolean)receiverThread.equals(flowThread));
        Assert.assertFalse((boolean)flowThread.equals(dispatcherThread));
        Assert.assertFalse((boolean)receiverThread.equals(dispatcherThread));
    }

    @Override
    public void testRequestResponseInboundFailingOneWayOutbound() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        try {
            client.send("vm://requestresponse-failingoneway-in", (Object)"a", null);
            Assert.fail((String)"exception expected");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

