/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.construct;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.processor.MessageProcessor;
import org.mule.tck.junit4.FunctionalTestCase;

public class FlowAsyncBeforeAfterOutboundTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/construct/flow-async-before-after-outbound.xml";
    }

    @Test
    public void testAsyncBefore() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage msgSync = client.send("vm://test.before.sync.in", (Object)"message", null);
        MuleMessage msgAsync = client.request("vm://test.before.async.out", 5000L);
        MuleMessage msgOut = client.request("vm://test.before.out", 5000L);
        this.assertCorrectThreads(msgSync, msgAsync, msgOut);
    }

    @Test
    public void testAsyncAfter() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage msgSync = client.send("vm://test.after.sync.in", (Object)"message", null);
        MuleMessage msgAsync = client.request("vm://test.after.async.out", 5000L);
        MuleMessage msgOut = client.request("vm://test.after.out", 5000L);
        this.assertCorrectThreads(msgSync, msgAsync, msgOut);
    }

    private void assertCorrectThreads(MuleMessage msgSync, MuleMessage msgAsync, MuleMessage msgOut) throws Exception {
        Assert.assertNotNull((Object)msgSync);
        Assert.assertNotNull((Object)msgAsync);
        Assert.assertNotNull((Object)msgOut);
        Assert.assertTrue((boolean)msgSync.getInboundProperty("request-response-thread").equals(msgOut.getInboundProperty("request-response-thread")));
        Assert.assertTrue((!msgAsync.getInboundProperty("async-thread").equals(msgSync.getInboundProperty("request-response-thread")) ? 1 : 0) != 0);
        Assert.assertTrue((!msgAsync.getInboundProperty("async-thread").equals(msgOut.getInboundProperty("request-response-thread")) ? 1 : 0) != 0);
    }

    public static class ThreadSensingMessageProcessor
    implements MessageProcessor {
        public MuleEvent process(MuleEvent event) throws MuleException {
            String propName = (String)event.getMessage().getInvocationProperty("property-name");
            event.getMessage().setOutboundProperty(propName, (Object)Thread.currentThread().getName());
            return event;
        }
    }
}

