/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.processor.ProcessingStrategy;
import org.mule.config.spring.util.ProcessingStrategyUtils;
import org.mule.processor.strategy.QueuedAsynchronousProcessingStrategy;
import org.mule.processor.strategy.QueuedThreadPerProcessorProcessingStrategy;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.SystemProperty;

@RunWith(value=Parameterized.class)
public class SystemPropertyProcessingStrategyConfigTestCase
extends FunctionalTestCase {
    private final String[] configFiles;
    private Class<? extends ProcessingStrategy> expectedStrategyType;
    @Rule
    public SystemProperty globalProcessingStrategy = new SystemProperty("mule.default.processing.strategy", ProcessingStrategyUtils.QUEUED_THREAD_PER_PROCESSOR_PROCESSING_STRATEGY);
    @Rule
    public SystemProperty localProcessingStrategy = new SystemProperty("processingStrategy", ProcessingStrategyUtils.QUEUED_ASYNC_PROCESSING_STRATEGY);

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"Container level system property", new String[0], QueuedThreadPerProcessorProcessingStrategy.class}, {"Configuration overrides system property", new String[]{"configuration-processing-strategy-config.xml"}, QueuedAsynchronousProcessingStrategy.class});
    }

    public SystemPropertyProcessingStrategyConfigTestCase(String name, String[] configFiles, Class<? extends ProcessingStrategy> expectedStrategyType) {
        this.configFiles = configFiles;
        this.expectedStrategyType = expectedStrategyType;
    }

    protected String[] getConfigFiles() {
        return this.configFiles;
    }

    @Test
    public void assertDefaultProcessingStrategy() throws Exception {
        Assert.assertThat((Object)muleContext.getConfiguration().getDefaultProcessingStrategy(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(this.expectedStrategyType)));
    }
}

