/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.EndpointException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.routing.filters.ExpressionFilter;
import org.mule.tck.junit4.FunctionalTestCase;

public class ExpressionFilterConfigTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/config/expression-filter-config.xml";
    }

    @Test
    public void testConfig1() throws Exception {
        EndpointBuilder eb = muleContext.getRegistry().lookupEndpointBuilder("endpoint1");
        Assert.assertNotNull((Object)eb);
        InboundEndpoint ep = eb.buildInboundEndpoint();
        Assert.assertNotNull((Object)ep.getFilter());
        Assert.assertTrue((boolean)(ep.getFilter() instanceof ExpressionFilter));
        ExpressionFilter filter = (ExpressionFilter)ep.getFilter();
        Assert.assertEquals((Object)"payload-type", (Object)filter.getEvaluator());
        Assert.assertEquals((Object)"java.lang.String", (Object)filter.getExpression());
        Assert.assertNull((Object)filter.getCustomEvaluator());
        Assert.assertFalse((boolean)filter.isNullReturnsTrue());
    }

    @Test
    public void testConfig2() throws Exception {
        EndpointBuilder eb = muleContext.getRegistry().lookupEndpointBuilder("endpoint2");
        Assert.assertNotNull((Object)eb);
        InboundEndpoint ep = eb.buildInboundEndpoint();
        Assert.assertNotNull((Object)ep.getFilter());
        Assert.assertTrue((boolean)(ep.getFilter() instanceof ExpressionFilter));
        ExpressionFilter filter = (ExpressionFilter)ep.getFilter();
        Assert.assertEquals((Object)"header", (Object)filter.getEvaluator());
        Assert.assertEquals((Object)"foo=bar", (Object)filter.getExpression());
        Assert.assertNull((Object)filter.getCustomEvaluator());
        Assert.assertTrue((boolean)filter.isNullReturnsTrue());
    }

    @Test
    public void testConfig3() throws Exception {
        EndpointBuilder eb = muleContext.getRegistry().lookupEndpointBuilder("endpoint3");
        Assert.assertNotNull((Object)eb);
        InboundEndpoint ep = eb.buildInboundEndpoint();
        Assert.assertNotNull((Object)ep.getFilter());
        Assert.assertTrue((boolean)(ep.getFilter() instanceof ExpressionFilter));
        ExpressionFilter filter = (ExpressionFilter)ep.getFilter();
        Assert.assertEquals((Object)"custom", (Object)filter.getEvaluator());
        Assert.assertEquals((Object)"a.b.c", (Object)filter.getExpression());
        Assert.assertEquals((Object)"something", (Object)filter.getCustomEvaluator());
        Assert.assertFalse((boolean)filter.isNullReturnsTrue());
    }

    @Test
    public void configNonBooleanReturnsFalse() throws Exception {
        ExpressionFilter filter = this.getFilter("endpoint4");
        MatcherAssert.assertThat((Object)filter.isNonBooleanReturnsTrue(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"yes", muleContext)), (Matcher)Matchers.is((Object)false));
        this.checkBooleanValuesAreNotChanged(filter);
    }

    @Test
    public void configNonBooleanReturnsTrue() throws Exception {
        ExpressionFilter filter = this.getFilter("endpoint5");
        MatcherAssert.assertThat((Object)filter.isNonBooleanReturnsTrue(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"yes", muleContext)), (Matcher)Matchers.is((Object)true));
        this.checkBooleanValuesAreNotChanged(filter);
    }

    private void checkBooleanValuesAreNotChanged(ExpressionFilter filter) {
        MatcherAssert.assertThat((Object)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"false", muleContext)), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"FaLsE", muleContext)), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"true", muleContext)), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)filter.accept((MuleMessage)new DefaultMuleMessage((Object)"TrUe", muleContext)), (Matcher)Matchers.is((Object)true));
    }

    private ExpressionFilter getFilter(String endpointName) throws EndpointException, InitialisationException {
        EndpointBuilder eb = muleContext.getRegistry().lookupEndpointBuilder(endpointName);
        Assert.assertNotNull((Object)eb);
        InboundEndpoint ep = eb.buildInboundEndpoint();
        MatcherAssert.assertThat((Object)ep.getFilter(), (Matcher)IsInstanceOf.instanceOf(ExpressionFilter.class));
        return (ExpressionFilter)ep.getFilter();
    }
}

