/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.Closure;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.comparators.ComparableComparator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.collection.IsMapContaining;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.DefaultMuleException;
import org.mule.api.config.ConfigurationException;
import org.mule.api.registry.ResolverException;
import org.mule.config.ExceptionHelper;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.util.SystemUtils;

@SmallTest
public class ExceptionHelperTestCase
extends AbstractMuleTestCase {
    @Test
    public void nestedExceptionRetrieval() throws Exception {
        Exception testException = this.getException();
        Throwable t = ExceptionHelper.getRootException((Throwable)testException);
        Assert.assertNotNull((Object)t);
        Assert.assertThat((Object)t.getMessage(), (Matcher)CoreMatchers.is((Object)"blah"));
        Assert.assertThat((Object)t.getCause(), (Matcher)CoreMatchers.nullValue());
        t = ExceptionHelper.getRootMuleException((Throwable)testException);
        Assert.assertThat((Object)t.getMessage(), (Matcher)CoreMatchers.is((Object)"bar"));
        Assert.assertThat((Object)t.getCause(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        List l = ExceptionHelper.getExceptionsAsList((Throwable)testException);
        Assert.assertThat((Object)l, (Matcher)IsCollectionWithSize.hasSize((int)3));
        Map info = ExceptionHelper.getExceptionInfo((Throwable)testException);
        Assert.assertThat(info.entrySet(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat((Object)info, (Matcher)IsMapContaining.hasEntry((Object)"info_1", (Object)"Imma in!"));
        Assert.assertThat((Object)info, (Matcher)IsMapContaining.hasEntry((Object)"info_2", (Object)"Imma out!"));
    }

    @Test
    public void summarizeWithDepthBeyondStackTraceLength() {
        Exception exception = this.getException();
        int numberOfStackFrames = exception.getStackTrace().length;
        int depth = numberOfStackFrames + 1;
        Throwable summary = ExceptionHelper.summarise((Throwable)exception, (int)depth);
        Assert.assertThat((Object)summary, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void getNonMuleExceptionCause() {
        Assert.assertThat((Object)ExceptionHelper.getNonMuleException((Throwable)new ResolverException(CoreMessages.failedToBuildMessage(), null)), (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)ExceptionHelper.getNonMuleException((Throwable)new ResolverException(CoreMessages.failedToBuildMessage(), (Throwable)new ConfigurationException(CoreMessages.failedToBuildMessage(), null))), (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)ExceptionHelper.getNonMuleException((Throwable)new ResolverException(CoreMessages.failedToBuildMessage(), (Throwable)new ConfigurationException(CoreMessages.failedToBuildMessage(), (Throwable)new IllegalArgumentException()))), (Matcher)IsInstanceOf.instanceOf(IllegalArgumentException.class));
        Assert.assertThat((Object)ExceptionHelper.getNonMuleException((Throwable)new ResolverException(CoreMessages.failedToBuildMessage(), (Throwable)new ConfigurationException(CoreMessages.failedToBuildMessage(), (Throwable)new IllegalArgumentException(new NullPointerException())))), (Matcher)IsInstanceOf.instanceOf(IllegalArgumentException.class));
        Assert.assertThat((Object)ExceptionHelper.getNonMuleException((Throwable)new IllegalArgumentException()), (Matcher)IsInstanceOf.instanceOf(IllegalArgumentException.class));
    }

    @Test
    public void filteredStackIncludingNonMuleCode() {
        int calls = 5;
        try {
            this.generateStackEntries(calls, new Closure(){

                public void execute(Object input) {
                    CollectionUtils.forAllDo(Collections.singleton(null), (Closure)new Closure(){

                        public void execute(Object input) {
                            throw new RuntimeException((Throwable)new DefaultMuleException(MessageFactory.createStaticMessage((String)"foo")));
                        }
                    });
                }
            });
            Assert.fail((String)"Expected exception");
        }
        catch (Exception e) {
            Assert.assertThat((Object)ExceptionHelper.getExceptionStack((Throwable)e), (Matcher)StringByLineMatcher.matchesLineByLine("foo \\(org.mule.api.DefaultMuleException\\)", "  org.mule.test.config.ExceptionHelperTestCase\\$1\\$1.execute\\(ExceptionHelperTestCase.java:[0-9]+\\)", "  org.apache.commons.collections.CollectionUtils.forAllDo\\(CollectionUtils.java:[0-9]+\\)", "  org.mule.test.config.ExceptionHelperTestCase\\$1.execute\\(ExceptionHelperTestCase.java:[0-9]+\\)", "  org.mule.test.config.ExceptionHelperTestCase.generateStackEntries\\(ExceptionHelperTestCase.java:[0-9]+\\)", "  \\(" + (calls + 15) + " more...\\)"));
        }
    }

    @Test
    public void filteredStackIncludingMixedNonMuleCode() {
        int calls = 5;
        try {
            this.generateStackEntries(calls, new Closure(){

                public void execute(Object input) {
                    Comparable exceptionComparable = new Comparable(){

                        public int compareTo(Object o) {
                            throw new RuntimeException((Throwable)new DefaultMuleException(MessageFactory.createStaticMessage((String)"foo")));
                        }
                    };
                    Collections.sort(Arrays.asList(exceptionComparable, exceptionComparable), ComparableComparator.getInstance());
                }
            });
            Assert.fail((String)"Expected exception");
        }
        catch (Exception e) {
            Assert.assertThat((Object)ExceptionHelper.getExceptionStack((Throwable)e), (Matcher)StringByLineMatcher.matchesLineByLine("foo \\(org.mule.api.DefaultMuleException\\)", "  org.mule.test.config.ExceptionHelperTestCase\\$2\\$1.compareTo\\(ExceptionHelperTestCase.java:[0-9]+\\)", "  org.apache.commons.collections.comparators.ComparableComparator.compare\\(ComparableComparator.java:[0-9]+\\)", "  java.util.*", "  java.util.*", "  java.util.*", "  java.util.*", "  java.util.*", "  org.mule.test.config.ExceptionHelperTestCase\\$2.execute\\(ExceptionHelperTestCase.java:[0-9]+\\)", "  org.mule.test.config.ExceptionHelperTestCase.generateStackEntries\\(ExceptionHelperTestCase.java:[0-9]+\\)", "  \\(" + (calls + 15) + " more...\\)"));
        }
    }

    @Test
    public void filteredStackAllMuleCode() {
        int calls = 5;
        try {
            this.generateStackEntries(calls, new Closure(){

                public void execute(Object input) {
                    throw new RuntimeException((Throwable)new DefaultMuleException(MessageFactory.createStaticMessage((String)"foo")));
                }
            });
        }
        catch (Exception e) {
            Assert.assertThat((Object)ExceptionHelper.getExceptionStack((Throwable)e), (Matcher)StringByLineMatcher.matchesLineByLine("foo \\(org.mule.api.DefaultMuleException\\)", "  org.mule.test.config.ExceptionHelperTestCase\\$3.execute\\(ExceptionHelperTestCase.java:[0-9]+\\)", "  org.mule.test.config.ExceptionHelperTestCase.generateStackEntries\\(ExceptionHelperTestCase.java:[0-9]+\\)", "  org.mule.test.config.ExceptionHelperTestCase.generateStackEntries\\(ExceptionHelperTestCase.java:[0-9]+\\)", "  \\(" + (calls + 14) + " more...\\)"));
        }
    }

    private void generateStackEntries(int calls, Closure closure) {
        if (calls == 0) {
            closure.execute(null);
        } else {
            this.generateStackEntries(--calls, closure);
        }
    }

    private Exception getException() {
        DefaultMuleException innerMuleException = new DefaultMuleException(MessageFactory.createStaticMessage((String)"bar"), (Throwable)new Exception("blah"));
        innerMuleException.addInfo("info_1", (Object)"Imma in!");
        DefaultMuleException outerMuleException = new DefaultMuleException(MessageFactory.createStaticMessage((String)"foo"), (Throwable)innerMuleException);
        outerMuleException.addInfo("info_1", (Object)"Imma out!");
        outerMuleException.addInfo("info_2", (Object)"Imma out!");
        return outerMuleException;
    }

    private static final class StringByLineMatcher
    extends TypeSafeMatcher<String> {
        private final String[] expectedEntries;
        private int i = 0;

        private StringByLineMatcher(String ... expectedEntries) {
            this.expectedEntries = expectedEntries;
        }

        public void describeTo(Description description) {
            description.appendText(String.format("line %d matches \"%s\"", this.i, this.expectedEntries[this.i]));
        }

        protected boolean matchesSafely(String item) {
            String[] stackEntries = item.split(SystemUtils.LINE_SEPARATOR);
            if (stackEntries.length != this.expectedEntries.length) {
                return false;
            }
            for (String expectedEntry : this.expectedEntries) {
                if (!stackEntries[this.i].matches(expectedEntry)) {
                    return false;
                }
                ++this.i;
            }
            return true;
        }

        public static StringByLineMatcher matchesLineByLine(String ... expectedEntries) {
            return new StringByLineMatcher(expectedEntries);
        }
    }
}

