/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config;

import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.processor.ProcessingStrategy;
import org.mule.config.spring.util.ProcessingStrategyUtils;
import org.mule.construct.flow.DefaultFlowProcessingStrategy;
import org.mule.processor.strategy.AsynchronousProcessingStrategy;
import org.mule.processor.strategy.QueuedAsynchronousProcessingStrategy;
import org.mule.processor.strategy.QueuedThreadPerProcessorProcessingStrategy;
import org.mule.processor.strategy.SynchronousProcessingStrategy;
import org.mule.processor.strategy.ThreadPerProcessorProcessingStrategy;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.SystemProperty;

@RunWith(value=Parameterized.class)
public class ConfigurationProcessingStrategyParserTestCase
extends FunctionalTestCase {
    private final Class<? extends ProcessingStrategy> expectedStrategyType;
    @Rule
    public SystemProperty processingStrategyProperty;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({ProcessingStrategyUtils.DEFAULT_PROCESSING_STRATEGY, DefaultFlowProcessingStrategy.class}, {ProcessingStrategyUtils.SYNC_PROCESSING_STRATEGY, SynchronousProcessingStrategy.class}, {ProcessingStrategyUtils.ASYNC_PROCESSING_STRATEGY, AsynchronousProcessingStrategy.class}, {ProcessingStrategyUtils.QUEUED_ASYNC_PROCESSING_STRATEGY, QueuedAsynchronousProcessingStrategy.class}, {ProcessingStrategyUtils.THREAD_PER_PROCESSOR_PROCESSING_STRATEGY, ThreadPerProcessorProcessingStrategy.class}, {ProcessingStrategyUtils.QUEUED_THREAD_PER_PROCESSOR_PROCESSING_STRATEGY, QueuedThreadPerProcessorProcessingStrategy.class});
    }

    public ConfigurationProcessingStrategyParserTestCase(String defaultProcessingStrategy, Class<? extends ProcessingStrategy> expectedStrategyType) {
        this.expectedStrategyType = expectedStrategyType;
        this.processingStrategyProperty = new SystemProperty("processingStrategy", defaultProcessingStrategy);
    }

    protected String getConfigFile() {
        return "configuration-processing-strategy-config.xml";
    }

    @Test
    public void verifyConfigurationProcessingStrategy() throws Exception {
        Assert.assertThat((Object)muleContext.getConfiguration().getDefaultProcessingStrategy(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(this.expectedStrategyType)));
    }
}

