/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config;

import javax.xml.namespace.QName;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.AnnotatedObject;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.transformer.Transformer;
import org.mule.component.DefaultJavaComponent;
import org.mule.construct.Flow;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.SystemUtils;

public class ConfigurationAnnotationsTestCase
extends FunctionalTestCase {
    protected String[] getConfigFiles() {
        return new String[]{"org/mule/config/spring/annotations.xml", "org/mule/config/spring/annotations-config.xml"};
    }

    @Test
    public void testTransformerAnnotations() {
        Transformer stb = muleContext.getRegistry().lookupTransformer("StringtoByteArray");
        Assert.assertThat((Object)stb, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)this.getDocName(stb), (Matcher)CoreMatchers.is((Object)"stb-transformer"));
        Assert.assertThat((Object)this.getDocDescription(stb), (Matcher)CoreMatchers.is((Object)"Convert a String to a Byte Array"));
        Assert.assertThat((Object)this.getSourceFile(stb), (Matcher)CoreMatchers.is((Object)"annotations-config.xml"));
        Assert.assertThat((Object)this.getSourceFileLine(stb), (Matcher)CoreMatchers.is((Object)10));
        Assert.assertThat((Object)this.getSourceElement(stb), (Matcher)CoreMatchers.is((Object)("<string-to-byte-array-transformer name=\"StringtoByteArray\" doc:name=\"stb-transformer\">" + SystemUtils.LINE_SEPARATOR + "<annotations>" + SystemUtils.LINE_SEPARATOR + "<doc:description>Convert a String to a Byte Array</doc:description>" + SystemUtils.LINE_SEPARATOR + "</annotations>" + SystemUtils.LINE_SEPARATOR + "</string-to-byte-array-transformer>")));
    }

    @Test
    public void testEndpointBuilderAnnotations() {
        EndpointBuilder in = muleContext.getRegistry().lookupEndpointBuilder("in");
        Assert.assertThat((Object)in, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)this.getDocName(in), (Matcher)CoreMatchers.is((Object)"inbound vm endpoint"));
        Assert.assertThat((Object)this.getDocDescription(in), (Matcher)CoreMatchers.is((Object)"Accepts inbound messages"));
        Assert.assertThat((Object)this.getSourceFile(in), (Matcher)CoreMatchers.is((Object)"annotations-config.xml"));
        Assert.assertThat((Object)this.getSourceFileLine(in), (Matcher)CoreMatchers.is((Object)16));
        Assert.assertThat((Object)this.getSourceElement(in), (Matcher)CoreMatchers.is((Object)("<endpoint name=\"in\" address=\"vm://in\" exchange-pattern=\"request-response\" doc:name=\"inbound vm endpoint\">" + SystemUtils.LINE_SEPARATOR + "<annotations>" + SystemUtils.LINE_SEPARATOR + "<doc:description>Accepts inbound messages</doc:description>" + SystemUtils.LINE_SEPARATOR + "</annotations>" + SystemUtils.LINE_SEPARATOR + "</endpoint>")));
    }

    @Test
    public void testFlowAnnotations() {
        FlowConstruct flow = muleContext.getRegistry().lookupFlowConstruct("Bridge");
        Assert.assertThat((Object)flow, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)this.getDocName(flow), (Matcher)CoreMatchers.is((Object)"Bridge flow"));
        Assert.assertThat((Object)this.getDocDescription(flow), (Matcher)CoreMatchers.is((Object)"Main flow"));
        Assert.assertThat((Object)this.getSourceFile(flow), (Matcher)CoreMatchers.is((Object)"annotations.xml"));
        Assert.assertThat((Object)this.getSourceFileLine(flow), (Matcher)CoreMatchers.is((Object)10));
        Assert.assertThat((Object)this.getSourceElement(flow), (Matcher)CoreMatchers.is((Object)("<flow name=\"Bridge\" doc:name=\"Bridge flow\">" + SystemUtils.LINE_SEPARATOR + "<annotations>" + SystemUtils.LINE_SEPARATOR + "<doc:description>Main flow</doc:description>" + SystemUtils.LINE_SEPARATOR + "</annotations>" + SystemUtils.LINE_SEPARATOR + "<inbound-endpoint ref=\"in\" doc:name=\"inbound flow endpoint\">" + SystemUtils.LINE_SEPARATOR + "<transformer ref=\"StringtoByteArray\"></transformer>" + SystemUtils.LINE_SEPARATOR + "</inbound-endpoint>" + SystemUtils.LINE_SEPARATOR + "<echo-component doc:name=\"echo\"></echo-component>" + SystemUtils.LINE_SEPARATOR + "<outbound-endpoint ref=\"out\"></outbound-endpoint>" + SystemUtils.LINE_SEPARATOR + "</flow>")));
    }

    @Test
    public void testFlowWithExceptionStrategyAnnotations() {
        FlowConstruct flow = muleContext.getRegistry().lookupFlowConstruct("WithRefExceptionStrategy");
        Assert.assertThat((Object)flow, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)this.getDocName(flow), (Matcher)CoreMatchers.is((Object)"With Referenced Exception Strategy"));
        Assert.assertThat((Object)this.getDocDescription(flow), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)this.getSourceFile(flow), (Matcher)CoreMatchers.is((Object)"annotations.xml"));
        Assert.assertThat((Object)this.getSourceFileLine(flow), (Matcher)CoreMatchers.is((Object)28));
        Assert.assertThat((Object)this.getSourceElement(flow), (Matcher)CoreMatchers.is((Object)("<flow name=\"WithRefExceptionStrategy\" doc:name=\"With Referenced Exception Strategy\">" + SystemUtils.LINE_SEPARATOR + "<echo-component doc:name=\"echo\"></echo-component>" + SystemUtils.LINE_SEPARATOR + "<exception-strategy ref=\"Catch_Exception_Strategy\" doc:name=\"Reference Exception Strategy\"></exception-strategy>" + SystemUtils.LINE_SEPARATOR + "</flow>")));
    }

    @Test
    public void testDefaultAnnotationsInNotAnnotatedObject() {
        FlowConstruct flow = muleContext.getRegistry().lookupFlowConstruct("NotAnnotatedBridge");
        Assert.assertThat((Object)flow, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)this.getDocName(flow), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)this.getDocDescription(flow), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)this.getSourceFile(flow), (Matcher)CoreMatchers.is((Object)"annotations.xml"));
        Assert.assertThat((Object)this.getSourceFileLine(flow), (Matcher)CoreMatchers.is((Object)23));
        Assert.assertThat((Object)this.getSourceElement(flow), (Matcher)CoreMatchers.is((Object)("<flow name=\"NotAnnotatedBridge\">" + SystemUtils.LINE_SEPARATOR + "<inbound-endpoint ref=\"notAnnotatedIn\"></inbound-endpoint>" + SystemUtils.LINE_SEPARATOR + "<echo-component></echo-component>" + SystemUtils.LINE_SEPARATOR + "</flow>")));
    }

    @Test
    public void testJavaComponentAnnotations() {
        AssertionError lastError = null;
        for (DefaultJavaComponent echo : muleContext.getRegistry().lookupByType(DefaultJavaComponent.class).values()) {
            try {
                Assert.assertThat((Object)this.getDocName(echo), (Matcher)CoreMatchers.is((Object)"echo"));
                Assert.assertThat((Object)this.getSourceFile(echo), (Matcher)CoreMatchers.is((Object)"annotations.xml"));
                Assert.assertThat((Object)this.getSourceFileLine(echo), (Matcher)CoreMatchers.is((Object)17));
                Assert.assertThat((Object)this.getSourceElement(echo), (Matcher)CoreMatchers.is((Object)"<echo-component doc:name=\"echo\"></echo-component>"));
                lastError = null;
                break;
            }
            catch (AssertionError e) {
                lastError = e;
            }
        }
        if (lastError != null) {
            throw lastError;
        }
    }

    @Test
    public void testInboundEndpointAnnotations() {
        FlowConstruct flow = muleContext.getRegistry().lookupFlowConstruct("Bridge");
        ImmutableEndpoint ep = (ImmutableEndpoint)((Flow)flow).getMessageSource();
        Assert.assertThat((Object)ep, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)this.getDocName(ep), (Matcher)CoreMatchers.is((Object)"inbound flow endpoint"));
        Assert.assertThat((String)"Accepts inbound messages", (Object)this.getDocDescription(ep), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((Object)this.getSourceFile(ep), (Matcher)CoreMatchers.is((Object)"annotations.xml"));
        Assert.assertThat((Object)this.getSourceFileLine(ep), (Matcher)CoreMatchers.is((Object)14));
        Assert.assertThat((Object)this.getSourceElement(ep), (Matcher)CoreMatchers.is((Object)("<inbound-endpoint ref=\"in\" doc:name=\"inbound flow endpoint\">" + SystemUtils.LINE_SEPARATOR + "<transformer ref=\"StringtoByteArray\"></transformer>" + SystemUtils.LINE_SEPARATOR + "</inbound-endpoint>")));
    }

    @Test
    public void testOutboundEndpointAnnotations() {
        OutboundEndpoint out = (OutboundEndpoint)muleContext.getRegistry().lookupByType(OutboundEndpoint.class).values().iterator().next();
        Assert.assertThat((Object)out, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)this.getDocName(out), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)this.getDocDescription(out), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)this.getSourceFile(out), (Matcher)CoreMatchers.is((Object)"annotations.xml"));
        Assert.assertThat((Object)this.getSourceFileLine(out), (Matcher)CoreMatchers.is((Object)18));
        Assert.assertThat((Object)this.getSourceElement(out), (Matcher)CoreMatchers.is((Object)"<outbound-endpoint ref=\"out\"></outbound-endpoint>"));
    }

    @Test
    public void testInsideSpringBeansAnnotations() {
        Transformer stb = muleContext.getRegistry().lookupTransformer("ManziTransformer");
        Assert.assertThat((Object)stb, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        Assert.assertThat((Object)this.getDocName(stb), (Matcher)CoreMatchers.is((Object)"manzi-transformer"));
        Assert.assertThat((Object)this.getSourceFile(stb), (Matcher)CoreMatchers.is((Object)"annotations-config.xml"));
        Assert.assertThat((Object)this.getSourceFileLine(stb), (Matcher)CoreMatchers.is((Object)30));
        Assert.assertThat((Object)this.getSourceElement(stb), (Matcher)CoreMatchers.is((Object)"<append-string-transformer message=\"Manzi\" name=\"ManziTransformer\" doc:name=\"manzi-transformer\"></append-string-transformer>"));
    }

    protected String getDocName(Object obj) {
        return (String)((AnnotatedObject)obj).getAnnotation(new QName("http://www.mulesoft.org/schema/mule/documentation", "name"));
    }

    protected String getDocDescription(Object obj) {
        return (String)((AnnotatedObject)obj).getAnnotation(new QName("http://www.mulesoft.org/schema/mule/documentation", "description"));
    }

    protected String getSourceFile(Object obj) {
        return (String)((AnnotatedObject)obj).getAnnotation(new QName("http://www.mulesoft.org/schema/mule/documentation", "sourceFileName"));
    }

    protected Integer getSourceFileLine(Object obj) {
        return (Integer)((AnnotatedObject)obj).getAnnotation(new QName("http://www.mulesoft.org/schema/mule/documentation", "sourceFileLine"));
    }

    protected String getSourceElement(Object obj) {
        return (String)((AnnotatedObject)obj).getAnnotation(new QName("http://www.mulesoft.org/schema/mule/documentation", "sourceElement"));
    }
}

