/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.components;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.registry.MuleRegistry;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.services.UniqueComponent;

public class ObjectFactoryTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/components/object-factory-functional-test.xml";
    }

    @Test
    public void testDefaultScope() throws Exception {
        MuleRegistry registry = muleContext.getRegistry();
        Object bean1 = registry.lookupObject("default");
        Assert.assertNotNull((Object)bean1);
        String id1 = ((UniqueComponent)bean1).getId();
        Object bean2 = registry.lookupObject("default");
        Assert.assertNotNull((Object)bean2);
        String id2 = ((UniqueComponent)bean2).getId();
        Assert.assertEquals((Object)id1, (Object)id2);
    }

    @Test
    public void testSingletonScope() throws Exception {
        MuleRegistry registry = muleContext.getRegistry();
        Object bean1 = registry.lookupObject("singleton");
        Assert.assertNotNull((Object)bean1);
        String id1 = ((UniqueComponent)bean1).getId();
        Object bean2 = registry.lookupObject("singleton");
        Assert.assertNotNull((Object)bean2);
        String id2 = ((UniqueComponent)bean2).getId();
        Assert.assertEquals((Object)id1, (Object)id2);
    }

    @Test
    public void testPrototypeScope() throws Exception {
        MuleRegistry registry = muleContext.getRegistry();
        Object bean1 = registry.lookupObject("prototype");
        Assert.assertNotNull((Object)bean1);
        String id1 = ((UniqueComponent)bean1).getId();
        Object bean2 = registry.lookupObject("prototype");
        Assert.assertNotNull((Object)bean2);
        String id2 = ((UniqueComponent)bean2).getId();
        Assert.assertFalse((String)("IDs " + id1 + " and " + id2 + " should be different"), (boolean)id1.equals(id2));
    }
}

