/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleMessage;
import org.mule.api.endpoint.EndpointBuilder;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.endpoint.DynamicOutboundEndpoint;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class EndpointURITestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testEndpoints() throws Exception {
        EndpointUri[] uris;
        for (EndpointUri uri : uris = new EndpointUri[]{new EndpointUri("vm://#[header:INBOUND:prop1]/#[header:INBOUND:prop2]", "vm://apple/orange"), new EndpointUri("imap://mule%40mule.net:secretpassword@gmail.com:143"), new EndpointUri("vm://bucket:somefiles?query=%7B%22filename%22%3A%22foo%22%7D"), new EndpointUri("http://localhost:1313"), new EndpointUri("http://localhost:1313?${foo}", "http://localhost:1313?$[foo]"), new EndpointUri("vm://#[header:INBOUND:prop1]", "vm://apple")}) {
            if (!uri.isDynamic()) {
                InboundEndpoint ei = muleContext.getEndpointFactory().getInboundEndpoint(uri.getUri());
                uri.checkResultUri((ImmutableEndpoint)ei);
            }
            if (uri.getUri().startsWith("imap:")) continue;
            EndpointBuilder endpointBuilder = muleContext.getEndpointFactory().getEndpointBuilder(uri.getUri());
            endpointBuilder.setExchangePattern(MessageExchangePattern.ONE_WAY);
            OutboundEndpoint oi = muleContext.getEndpointFactory().getOutboundEndpoint(endpointBuilder);
            uri.checkResultUri((ImmutableEndpoint)oi);
        }
    }

    private static class EndpointUri {
        private String uri;
        private boolean isDynamic;
        private String resultUri;
        private MuleMessage message;

        public EndpointUri(String uri, String resultUri) {
            HashMap<String, String> inbound = new HashMap<String, String>();
            inbound.put("prop1", "apple");
            inbound.put("prop2", "orange");
            inbound.put("prop3", "banana");
            this.message = new DefaultMuleMessage((Object)"Hello, world", inbound, null, null, muleContext);
            this.uri = uri;
            this.resultUri = resultUri;
            this.isDynamic = true;
        }

        public EndpointUri(String uri) {
            this(uri, uri);
            this.isDynamic = false;
        }

        public String getUri() {
            return this.uri;
        }

        public boolean isDynamic() {
            return this.isDynamic;
        }

        public void checkResultUri(ImmutableEndpoint ep) {
            String epUri = ep instanceof DynamicOutboundEndpoint ? muleContext.getExpressionManager().parse(ep.getAddress(), this.message, true) : ep.getAddress();
            Assert.assertEquals((Object)this.resultUri, (Object)epUri);
        }
    }
}

