/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing.outbound;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;

public class AggregationTimeoutTestCase
extends FunctionalTestCase {
    private static final CountDownLatch blockExecution = new CountDownLatch(1);
    public static final String PROCESS_EVENT = "process";
    public static final String BLOCK_EVENT = "block";
    public static final String PROCESSED_EVENT = "processed";

    protected String getConfigFile() {
        return "org/mule/test/integration/routing/outbound/aggregation-timeout-config.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void timeoutsAggregationWithPersistentStore() throws Exception {
        ArrayList<String> inputData = new ArrayList<String>();
        inputData.add(PROCESS_EVENT);
        inputData.add(BLOCK_EVENT);
        try {
            LocalMuleClient client = muleContext.getClient();
            client.dispatch("vm://testIn", inputData, null);
            MuleMessage response = client.request("vm://testOut", 5000L);
            Assert.assertThat((Object)response.getPayload(), (Matcher)Matchers.instanceOf(List.class));
            List payload = (List)response.getPayload();
            Assert.assertThat((Object)payload.size(), (Matcher)Matchers.equalTo((Object)1));
            Assert.assertThat((Object)payload, (Matcher)Matchers.hasItem((Object)PROCESSED_EVENT));
        }
        finally {
            blockExecution.countDown();
        }
    }

    public static class BlockExecutionComponent {
        public Object onCall(Object payload) throws Exception {
            if (payload.equals(AggregationTimeoutTestCase.BLOCK_EVENT)) {
                blockExecution.await();
            }
            return AggregationTimeoutTestCase.PROCESSED_EVENT;
        }
    }
}

