/*
 * Decompiled with CFR 0.152.
 */
package org.mule.properties;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.transport.PropertyScope;
import org.mule.construct.Flow;
import org.mule.tck.functional.FlowAssert;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.Orange;

public class InvocationPropertiesTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");
    @Rule
    public DynamicPort dynamicPort2 = new DynamicPort("port2");
    @Rule
    public DynamicPort dynamicPort3 = new DynamicPort("port3");

    @Test
    public void setInvocationPropertyUsingAPIGetInFlow() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"data", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, InvocationPropertiesTestCase.getTestInboundEndpoint((String)""), (FlowConstruct)InvocationPropertiesTestCase.getTestService());
        message.setProperty("P1", (Object)"P1_VALUE", PropertyScope.INVOCATION);
        this.testFlow("GetInvocationPropertyInFlow", (MuleEvent)event);
    }

    @Test
    public void setInvocationPropertyInFlowGetUsingAPI() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"data", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, InvocationPropertiesTestCase.getTestInboundEndpoint((String)""), (FlowConstruct)InvocationPropertiesTestCase.getTestService());
        Flow flowA = (Flow)muleContext.getRegistry().lookupFlowConstruct("SetInvocationPropertyInFlow");
        MuleEvent result = flowA.process((MuleEvent)event);
        Assert.assertEquals((Object)"P1_VALUE", (Object)result.getMessage().getProperty("P1", PropertyScope.INVOCATION));
    }

    @Test
    public void overwritePropertyValueInFlow() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"data", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, InvocationPropertiesTestCase.getTestInboundEndpoint((String)""), (FlowConstruct)InvocationPropertiesTestCase.getTestService());
        message.setProperty("P1", (Object)"P1_VALUE", PropertyScope.INVOCATION);
        this.testFlow("OverwritePropertyValueInFlow", (MuleEvent)event);
        Assert.assertEquals((Object)"P1_VALUE_NEW", (Object)event.getMessage().getProperty("P1", PropertyScope.INVOCATION));
    }

    @Test
    public void propagationInSameFlow() throws Exception {
        this.testFlow("propagationInSameFlow");
    }

    @Test
    public void noPropagationInDifferentFlowVMRequestResponse() throws Exception {
        this.testFlow("noPropagationInDifferentFlowVMRequestResponse");
        FlowAssert.verify((String)"noPropagationInDifferentFlowVMRequestResponse-2");
    }

    @Test
    public void noPropagationInDifferentFlowVMOneWay() throws Exception {
        this.testFlow("noPropagationInDifferentFlowVMOneWay");
        FlowAssert.verify((String)"noPropagationInDifferentFlowVMOneWay-2");
    }

    @Test
    public void noPropagationInDifferentFlowHttp() throws Exception {
        this.testFlow("noPropagationInDifferentFlowHttp");
        FlowAssert.verify((String)"noPropagationInDifferentFlowHttp-2");
    }

    @Test
    public void propagationThroughOneWayFlowSedaQueue() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"data", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, InvocationPropertiesTestCase.getTestInboundEndpoint((String)""), (FlowConstruct)InvocationPropertiesTestCase.getTestService());
        Object nonSerializable = new Object();
        message.setInvocationProperty("P1", (Object)"value");
        message.setInvocationProperty("P2", nonSerializable);
        message.setInvocationProperty("testThread", (Object)Thread.currentThread());
        this.testFlow("AsyncFlow", (MuleEvent)event);
        Assert.assertNotNull((Object)message.getInvocationProperty("P1"));
        Assert.assertNotNull((Object)message.getInvocationProperty("P2"));
        Assert.assertNull((Object)message.getInvocationProperty("P3"));
    }

    @Test
    public void propagationWithVMRequestResponseOutboundEndpointMidFlow() throws Exception {
        this.testFlow("VMRequestResponseEndpointFlowMidFlow");
    }

    @Test
    public void propagationWithHTTPRequestResponseOutboundEndpointMidFlow() throws Exception {
        this.testFlow("HTTPRequestResponseEndpointFlowMidFlow");
    }

    @Test
    public void propagationThroughFlowRefToFlow() throws Exception {
        this.testFlow("propagationThroughFlowRefToFlow");
        FlowAssert.verify((String)"FlowRef-1");
        FlowAssert.verify((String)"FlowRef-2");
        FlowAssert.verify((String)"FlowRef-3");
    }

    @Test
    public void overwritePropertyValueInFlowViaFlowRef() throws Exception {
        this.testFlow("OverwriteInFlowRef");
    }

    @Test
    public void propagationThroughFlowRefToSubFlow() throws Exception {
        this.testFlow("propagationThroughFlowRefToSubFlow");
    }

    @Test
    public void overwritePropertyValueInSubFlowViaFlowRef() throws Exception {
        this.testFlow("OverwriteInSubFlowRef");
    }

    @Test
    public void propagationThroughAsyncElement() throws Exception {
        this.testFlow("propagationThroughAsyncElement");
    }

    @Test
    public void propertyAddedInAsyncElementNotAddedinFlow() throws Exception {
        this.testFlow("propertyAddedInAsyncElementNotAddedinFlow");
    }

    @Test
    public void propagationThroughWireTap() throws Exception {
        this.testFlow("propagationThroughWireTap");
    }

    @Test
    public void propertyAddedInWireTapNotAddedinFlow() throws Exception {
        this.testFlow("propertyAddedInWireTapNotAddedinFlow");
    }

    @Test
    public void propagationThroughEnricher() throws Exception {
        this.testFlow("propagationThroughEnricher");
    }

    @Test
    public void propertyAddedInEnricherNotAddedinFlow() throws Exception {
        this.testFlow("propertyAddedInEnricherNotAddedinFlow");
    }

    @Test
    public void propagateToRoutesInAll() throws Exception {
        this.testFlow("propagateToRoutesInAll");
    }

    @Test
    public void propagateThroughAllRouterWithResults() throws Exception {
        this.testFlow("propagateThroughAllRouterWithResults");
    }

    @Test
    public void propagateThroughAllRouterWithNoResults() throws Exception {
        this.testFlow("propagateThroughAllRouterWithNoResults");
    }

    @Test
    public void propagateBetweenRoutes() throws Exception {
        this.testFlow("propagateBetweenRoutes");
    }

    @Test
    public void propagateFromRouteToNextProcessorSingleRoute() throws Exception {
        this.testFlow("propagateFromRouteToNextProcessorSingleRoute");
    }

    @Test
    public void propagateFromRouteToNextProcessorMultipleRoutes() throws Exception {
        this.testFlow("propagateFromRouteToNextProcessorMultipleRoutes");
    }

    @Test
    public void propagateFromRouteToNextProcessorNoResult() throws Exception {
        this.testFlow("propagateFromRouteToNextProcessorNoResult");
    }

    @Test
    public void allAsync() throws Exception {
        this.testFlow("AllAsync");
    }

    @Test
    public void propogationOfPropertiesInMessageSplitWithSplitter() throws Exception {
        ArrayList<Object> fruitList = new ArrayList<Object>();
        fruitList.add(new Apple());
        fruitList.add(new Orange());
        fruitList.add(new Banana());
        this.testFlow("propogationOfPropertiesInMessageSplitWithSplitter", InvocationPropertiesTestCase.getTestEvent(fruitList));
    }

    @Test
    public void aggregationOfPropertiesFromMultipleMessageWithAggregator() throws Exception {
        ArrayList<Object> fruitList = new ArrayList<Object>();
        fruitList.add(new Apple());
        fruitList.add(new Orange());
        fruitList.add(new Banana());
        this.testFlow("aggregationOfPropertiesFromMultipleMessageWithAggregator", InvocationPropertiesTestCase.getTestEvent(fruitList));
        FlowAssert.verify((String)"Split");
    }

    @Test
    public void defaultExceptionStrategy() throws Exception {
        this.testFlow("defaultExceptionStrategy");
    }

    @Test
    public void catchExceptionStrategy() throws Exception {
        this.testFlow("catchExceptionStrategy");
    }

    @Test
    public void defaultExceptionStrategyAfterCallSubflow() throws Exception {
        muleContext.getClient().send("vm://in", (Object)"test", null, 5000L);
        FlowAssert.verify((String)"defaultExceptionStrategyAfterCallingSubflow");
    }

    protected String getConfigFile() {
        return "org/mule/properties/invocation-properties-config.xml";
    }
}

