/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.functional;

import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.api.transformer.Transformer;
import org.mule.expression.RegistryExpressionEvaluator;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.FruitBasket;

public class RegistryExpressionEvaluatorTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/integration/registry-expressions-test-config.xml";
    }

    @Test
    public void testSimpleRegistryLookup() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new Apple(), muleContext);
        RegistryExpressionEvaluator eval = new RegistryExpressionEvaluator();
        eval.setMuleContext(muleContext);
        Object o = eval.evaluate("bowlToBasket", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        Assert.assertTrue((boolean)(o instanceof Transformer));
        o = eval.evaluate("XXbowlToBasket*", (MuleMessage)message);
        Assert.assertNull((Object)o);
    }

    @Test(expected=ExpressionRuntimeException.class)
    public void testRegistryLookupWithProperties() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new Apple(), muleContext);
        RegistryExpressionEvaluator eval = new RegistryExpressionEvaluator();
        eval.setMuleContext(muleContext);
        Object o = eval.evaluate("bowlToBasket.returnClass", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        Assert.assertTrue((boolean)(o instanceof Class));
        Assert.assertEquals(FruitBasket.class, (Object)o);
        o = eval.evaluate("XXbowlToBasket*.returnClass", (MuleMessage)message);
        Assert.assertNull((Object)o);
        o = eval.evaluate("bowlToBasket.returnClass.name", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((Object)FruitBasket.class.getName(), (Object)o);
        o = eval.evaluate("bowlToBasket.returnClass.xname*", (MuleMessage)message);
        Assert.assertNull((Object)o);
        o = eval.evaluate("bowlToBasket.returnClass.xname", (MuleMessage)message);
    }

    @Test
    public void testGlobalEndpointRegistryLookupWithProperties() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)new Apple(), muleContext);
        RegistryExpressionEvaluator eval = new RegistryExpressionEvaluator();
        eval.setMuleContext(muleContext);
        Object o = eval.evaluate("myendpoint.toString", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        Assert.assertTrue((boolean)(o instanceof String));
        Assert.assertEquals((Object)"test://foo", (Object)o);
    }

    @Test(expected=ExpressionRuntimeException.class)
    public void testLookUpbyType() throws Exception {
        Apple apple = new Apple();
        muleContext.getRegistry().registerObject("apple", (Object)apple);
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"foo", muleContext);
        RegistryExpressionEvaluator eval = new RegistryExpressionEvaluator();
        eval.setMuleContext(muleContext);
        Object o = eval.evaluate("type:org.mule.tck.testmodels.fruit.Apple", (MuleMessage)message);
        Assert.assertNotNull((Object)o);
        Assert.assertEquals((Object)apple, (Object)o);
        o = eval.evaluate("banana", (MuleMessage)message);
    }
}

