/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.config;

import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.api.transformer.Transformer;
import org.mule.module.xml.config.CustomXsltTransformerFactory;
import org.mule.module.xml.transformer.AbstractXmlTransformer;
import org.mule.module.xml.transformer.DomDocumentToXml;
import org.mule.module.xml.transformer.JXPathExtractor;
import org.mule.module.xml.transformer.ObjectToXml;
import org.mule.module.xml.transformer.XmlToDomDocument;
import org.mule.module.xml.transformer.XmlToObject;
import org.mule.module.xml.transformer.XsltTransformer;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transformer.AbstractTransformer;

public class XmlTransformerNamespaceHandlerTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/module/xml/xml-transformer-namespace-test.xml";
    }

    @Test
    public void testDomToXml() {
        this.getAndTestTransformer("domToXml", DomDocumentToXml.class);
    }

    @Test
    public void testJXPathExtractor() {
        JXPathExtractor extractor = (JXPathExtractor)this.getAndTestTransformer("jxpathExtractor", JXPathExtractor.class);
        Assert.assertEquals((Object)"/expression", (Object)extractor.getExpression());
        Assert.assertFalse((boolean)extractor.isSingleResult());
        Assert.assertEquals((Object)"VALUE", (Object)extractor.getOutputType());
        Map ns = extractor.getNamespaces();
        Assert.assertNotNull((Object)ns);
        Assert.assertEquals((Object)"http://foo.com", ns.get("foo1"));
        Assert.assertEquals((Object)"http://foo.com", ns.get("foo2"));
    }

    @Test
    public void testObjectToXml() {
        ObjectToXml objectToXml = (ObjectToXml)this.getAndTestTransformer("objectToXml", ObjectToXml.class);
        Assert.assertTrue((boolean)objectToXml.isAcceptMuleMessage());
    }

    @Test
    public void testXmlToDom() {
        this.getAndTestTransformer("xmlToDom", XmlToDomDocument.class);
    }

    @Test
    public void testXmlToObject() {
        this.getAndTestTransformer("xmlToObject", XmlToObject.class);
    }

    @Test
    public void testXslt() {
        XsltTransformer xslt = (XsltTransformer)this.getAndTestTransformer("xslt", XsltTransformer.class);
        Assert.assertEquals((long)10L, (long)xslt.getMaxActiveTransformers());
        Assert.assertEquals((long)10L, (long)xslt.getMaxIdleTransformers());
        Assert.assertEquals((Object)CustomXsltTransformerFactory.class.getName(), (Object)xslt.getXslTransformerFactory());
        Assert.assertNull((Object)xslt.getXslFile());
        Assert.assertNotNull((Object)xslt.getXslt());
        String transform = xslt.getXslt();
        Assert.assertTrue((transform.indexOf("test for this string in test") > -1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"#[header:foo]", xslt.getContextProperties().get("bar"));
    }

    @Test
    public void testDomToXmlOnEndpoint() throws MuleException {
        this.getAndTestEndpointTransformer("ep1", DomDocumentToXml.class);
    }

    @Test
    public void testJXPathExtractorOnEndpoint() throws MuleException {
        JXPathExtractor extractor = (JXPathExtractor)this.getAndTestEndpointTransformer("ep2", JXPathExtractor.class);
        Assert.assertEquals((Object)"/expression", (Object)extractor.getExpression());
        Assert.assertFalse((boolean)extractor.isSingleResult());
    }

    @Test
    public void testObjectToXmlOnEndpoint() throws MuleException {
        ObjectToXml objectToXml = (ObjectToXml)this.getAndTestEndpointTransformer("ep3", ObjectToXml.class);
        Assert.assertTrue((boolean)objectToXml.isAcceptMuleMessage());
    }

    @Test
    public void testXmlToDomOnEndpoint() throws MuleException {
        this.getAndTestEndpointTransformer("ep4", XmlToDomDocument.class);
    }

    @Test
    public void testXmlToObjectOnEndpoint() throws MuleException {
        this.getAndTestEndpointTransformer("ep5", XmlToObject.class);
    }

    @Test
    public void testXsltOnEndpoint() throws MuleException {
        XsltTransformer xslt = (XsltTransformer)this.getAndTestEndpointTransformer("ep6", XsltTransformer.class);
        Assert.assertEquals((long)10L, (long)xslt.getMaxActiveTransformers());
        Assert.assertEquals((long)10L, (long)xslt.getMaxIdleTransformers());
        Assert.assertEquals((Object)CustomXsltTransformerFactory.class.getName(), (Object)xslt.getXslTransformerFactory());
        Assert.assertNotNull((Object)xslt.getXslt());
        String transform = xslt.getXslt();
        Assert.assertTrue((transform.indexOf("test for this string in test") > -1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"#[header:foo]", xslt.getContextProperties().get("bar"));
    }

    protected AbstractTransformer getAndTestTransformer(String name, Class clazz) {
        Assert.assertTrue((boolean)AbstractTransformer.class.isAssignableFrom(clazz));
        Transformer object = muleContext.getRegistry().lookupTransformer(name);
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)clazz.isAssignableFrom(object.getClass()));
        AbstractTransformer transformer = (AbstractTransformer)object;
        this.assertAbstractTransformerOk(transformer, name);
        return transformer;
    }

    protected AbstractTransformer getAndTestEndpointTransformer(String endpointName, Class clazz) throws MuleException {
        Assert.assertTrue((boolean)AbstractTransformer.class.isAssignableFrom(clazz));
        Assert.assertEquals((long)1L, (long)muleContext.getEndpointFactory().getInboundEndpoint(endpointName).getTransformers().size());
        AbstractTransformer transformer = (AbstractTransformer)muleContext.getEndpointFactory().getInboundEndpoint(endpointName).getTransformers().get(0);
        Assert.assertNotNull((Object)transformer);
        Assert.assertTrue((boolean)clazz.isAssignableFrom(transformer.getClass()));
        return transformer;
    }

    protected void assertAbstractTransformerOk(AbstractTransformer transformer, String name) {
        Assert.assertTrue((boolean)transformer.isIgnoreBadInput());
        Assert.assertEquals(Object.class, (Object)transformer.getReturnClass());
        Assert.assertEquals((Object)name, (Object)transformer.getName());
        if (transformer instanceof AbstractXmlTransformer) {
            Assert.assertEquals((Object)"foo", (Object)((AbstractXmlTransformer)transformer).getOutputEncoding());
        }
    }
}

