/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.api.routing.MatchableMessageProcessor;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.service.Service;
import org.mule.construct.Flow;
import org.mule.module.xml.filters.IsXmlFilter;
import org.mule.module.xml.filters.JXPathFilter;
import org.mule.routing.MessageFilter;
import org.mule.routing.filters.logic.NotFilter;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class XmlFilterNamespaceHandlerTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/module/xml/xml-filter-functional-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/module/xml/xml-filter-functional-test-flow.xml"});
    }

    public XmlFilterNamespaceHandlerTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testIsXmlFilter() throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException {
        Object serviceFlow = muleContext.getRegistry().lookupObject("test for xml");
        if (serviceFlow instanceof Service) {
            List routers = ((OutboundRouterCollection)((Service)serviceFlow).getOutboundMessageProcessor()).getRoutes();
            Assert.assertEquals((long)2L, (long)routers.size());
            Assert.assertTrue((String)((MatchableMessageProcessor)routers.get(0)).getClass().getName(), (boolean)(routers.get(0) instanceof FilteringOutboundRouter));
            Assert.assertTrue((boolean)(((FilteringOutboundRouter)routers.get(0)).getFilter() instanceof IsXmlFilter));
            Assert.assertTrue((String)((MatchableMessageProcessor)routers.get(1)).getClass().getName(), (boolean)(routers.get(1) instanceof FilteringOutboundRouter));
            Assert.assertTrue((boolean)(((FilteringOutboundRouter)routers.get(1)).getFilter() instanceof NotFilter));
            Assert.assertTrue((boolean)(((NotFilter)((FilteringOutboundRouter)routers.get(1)).getFilter()).getFilter() instanceof IsXmlFilter));
        } else if (serviceFlow instanceof Flow) {
            ArrayList outEndpoints = new ArrayList(2);
            outEndpoints.add(((Flow)serviceFlow).getMessageProcessors().get(0));
            MessageProcessorChain notXmlSubFlow = (MessageProcessorChain)muleContext.getRegistry().lookupObject("notXml");
            outEndpoints.add(notXmlSubFlow.getMessageProcessors().get(0));
            Assert.assertEquals((long)2L, (long)outEndpoints.size());
            Assert.assertTrue((String)((MessageProcessor)outEndpoints.get(0)).getClass().getName(), (boolean)(outEndpoints.get(0) instanceof MessageFilter));
            Assert.assertTrue((boolean)(((MessageFilter)outEndpoints.get(0)).getFilter() instanceof IsXmlFilter));
            Assert.assertTrue((String)((MessageProcessor)outEndpoints.get(1)).getClass().getName(), (boolean)(outEndpoints.get(1) instanceof MessageFilter));
            Assert.assertTrue((boolean)(((MessageFilter)outEndpoints.get(1)).getFilter() instanceof NotFilter));
            Assert.assertTrue((boolean)(((NotFilter)((MessageFilter)outEndpoints.get(1)).getFilter()).getFilter() instanceof IsXmlFilter));
        } else {
            Assert.fail((String)"Unexpected Object");
        }
    }

    @Test
    public void testJXPathFilter() {
        Object serviceFlow = null;
        serviceFlow = muleContext.getRegistry().lookupObject("filter xml for content");
        if (serviceFlow instanceof Service) {
            List routers = ((OutboundRouterCollection)((Service)serviceFlow).getOutboundMessageProcessor()).getRoutes();
            Assert.assertEquals((long)1L, (long)routers.size());
            Assert.assertTrue((String)((MatchableMessageProcessor)routers.get(0)).getClass().getName(), (boolean)(routers.get(0) instanceof FilteringOutboundRouter));
            Assert.assertTrue((boolean)(((FilteringOutboundRouter)routers.get(0)).getFilter() instanceof JXPathFilter));
            JXPathFilter filter = (JXPathFilter)((FilteringOutboundRouter)routers.get(0)).getFilter();
            Assert.assertEquals((Object)"filter xml for content", (Object)filter.getExpectedValue());
            Assert.assertEquals((Object)"/mule:mule/mule:model/mule:service[2]/@name", (Object)filter.getPattern());
            Assert.assertNotNull((Object)filter.getNamespaces());
            Map namespaces = filter.getNamespaces();
            Assert.assertEquals((long)2L, (long)namespaces.size());
            Assert.assertEquals((Object)"http://www.springframework.org/schema/beans", namespaces.get("spring"));
            Assert.assertTrue((boolean)namespaces.get("mule").toString().startsWith("http://www.mulesoft.org/schema/mule/core"));
        } else if (serviceFlow instanceof Flow) {
            ArrayList outEndpoints = new ArrayList(1);
            outEndpoints.add(((Flow)serviceFlow).getMessageProcessors().get(0));
            Assert.assertEquals((long)1L, (long)outEndpoints.size());
            Assert.assertTrue((String)((MessageProcessor)outEndpoints.get(0)).getClass().getName(), (boolean)(outEndpoints.get(0) instanceof MessageFilter));
            Assert.assertTrue((boolean)(((MessageFilter)outEndpoints.get(0)).getFilter() instanceof JXPathFilter));
            JXPathFilter filter = (JXPathFilter)((MessageFilter)outEndpoints.get(0)).getFilter();
            Assert.assertEquals((Object)"filter xml for content", (Object)filter.getExpectedValue());
            Assert.assertEquals((Object)"/mule:mule/mule:flow[2]/@name", (Object)filter.getPattern());
            Assert.assertNotNull((Object)filter.getNamespaces());
            Map namespaces = filter.getNamespaces();
            Assert.assertEquals((long)2L, (long)namespaces.size());
            Assert.assertEquals((Object)"http://www.springframework.org/schema/beans", namespaces.get("spring"));
            Assert.assertTrue((boolean)namespaces.get("mule").toString().startsWith("http://www.mulesoft.org/schema/mule/core"));
        } else {
            Assert.fail((String)"Unexpected Object");
        }
    }
}

