/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.xml.config;

import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.routing.MatchableMessageProcessor;
import org.mule.api.routing.OutboundRouterCollection;
import org.mule.api.service.Service;
import org.mule.module.xml.filters.IsXmlFilter;
import org.mule.module.xml.filters.JXPathFilter;
import org.mule.routing.filters.logic.NotFilter;
import org.mule.routing.outbound.FilteringOutboundRouter;
import org.mule.tck.junit4.FunctionalTestCase;

public class XmlFilterNamespaceHandlerServiceTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/module/xml/xml-filter-functional-test-service.xml";
    }

    @Test
    public void testIsXmlFilter() throws Exception {
        Service service = muleContext.getRegistry().lookupService("test for xml");
        List routers = ((OutboundRouterCollection)service.getOutboundMessageProcessor()).getRoutes();
        Assert.assertEquals((long)2L, (long)routers.size());
        Assert.assertTrue((String)((MatchableMessageProcessor)routers.get(0)).getClass().getName(), (boolean)(routers.get(0) instanceof FilteringOutboundRouter));
        Assert.assertTrue((boolean)(((FilteringOutboundRouter)routers.get(0)).getFilter() instanceof IsXmlFilter));
        Assert.assertTrue((String)((MatchableMessageProcessor)routers.get(1)).getClass().getName(), (boolean)(routers.get(1) instanceof FilteringOutboundRouter));
        Assert.assertTrue((boolean)(((FilteringOutboundRouter)routers.get(1)).getFilter() instanceof NotFilter));
        Assert.assertTrue((boolean)(((NotFilter)((FilteringOutboundRouter)routers.get(1)).getFilter()).getFilter() instanceof IsXmlFilter));
    }

    @Test
    public void testJXPathFilter() {
        Service service = muleContext.getRegistry().lookupService("filter xml for content");
        List routers = ((OutboundRouterCollection)service.getOutboundMessageProcessor()).getRoutes();
        Assert.assertEquals((long)1L, (long)routers.size());
        Assert.assertTrue((String)((MatchableMessageProcessor)routers.get(0)).getClass().getName(), (boolean)(routers.get(0) instanceof FilteringOutboundRouter));
        Assert.assertTrue((boolean)(((FilteringOutboundRouter)routers.get(0)).getFilter() instanceof JXPathFilter));
        JXPathFilter filter = (JXPathFilter)((FilteringOutboundRouter)routers.get(0)).getFilter();
        Assert.assertEquals((Object)"filter xml for content", (Object)filter.getExpectedValue());
        Assert.assertEquals((Object)"/mule:mule/mule:model/mule:service[2]/@name", (Object)filter.getPattern());
        Assert.assertNotNull((Object)filter.getNamespaces());
        Map namespaces = filter.getNamespaces();
        Assert.assertEquals((long)2L, (long)namespaces.size());
        Assert.assertEquals((Object)"http://www.springframework.org/schema/beans", namespaces.get("spring"));
        Assert.assertTrue((boolean)namespaces.get("mule").toString().startsWith("http://www.mulesoft.org/schema/mule/core"));
    }
}

